//
//
//
var spelamModuleScientificName;

(function(){
 'use strict';

 const SN = spelamModuleScientificName = {};

// all

 SN.format = function(options,input){

  if ( input == null ) {
   return undefined;
  }

  let italicBegin, italicEnd;
  let italicIndicators = options.italicIndicators;
  if ( italicIndicators && italicIndicators.trim() !== '' ) {
   let [begin,end] = italicIndicators.trim().split(/\s+/);
   if ( end === undefined ) { end = begin; }
   italicBegin = begin;
   italicEnd   = end;
  } else {
   italicBegin = '/';
   italicEnd   = '/';
  }

  function italicizeManual(text_in) {
   let text_out = '';
   let pos1, pos2;
   for( pos1 = 0;
      (pos2 = text_in.indexOf(italicBegin,pos1)) >= 0;
      pos1 = pos2 ){
    text_out += text_in.substring(pos1,pos2);
    pos1 = pos2+italicBegin.length;
    pos2 = text_in.indexOf(italicEnd,pos1);
    if ( pos2 >= 0 ) {
     if ( pos2-pos1 > 0 ) {
      text_out += '<i>'+text_in.substring(pos1,pos2)+'</i>';
     }
     pos2 += italicEnd.length;;
    }
    else {
     text_out += '<span class="error">'
      +text_in.substr(pos1-italicBegin.length)
      +'</span>';
     pos1 = text_in.length;
     break;
    }
   }
   text_out += text_in.substr(pos1);
   return text_out;
  }


  //
  function italicizeAuto(text_in){

   function italicizePrimary(text_in) {
    let text_out = '';

    // keyword unabbreviated
    const keywords = new Set([
     'subgenus', 'section', 'series',
     'x',
     'ex', 'et', 'in', 'lato', 'nec', 'non', 'sensu', 'strict',
    ]);

    // find specific name
    let re1 = /(^|\s|\u00d7)(?:([a-z][a-z\-\u2010\u2011]*)(\s|\)|$)|(sp\.|spp\.))/g;

    let a1;
    for( ; (a1 = re1.exec(text_in)) && !a1[4] && keywords.has(a1[2]); ) {}

    // before specific name (genus, subgenus, section, series)
    let text_gen = a1? text_in.substr(0,a1.index): text_in;

    // genus
    let re3 = /^([^A-Za-z]*)([A-Z][a-z\-\u2010\u2011\.]*)(\s|\)|$)/g;
    let a3 = re3.exec(text_gen);
    let pos = 0;
    if ( a3 ) { 
     text_out += a3[1]+'<i>'+a3[2]+'</i>'+a3[3];
     pos = re3.lastIndex;
    }

    // (subgenus)
    let re4 = /(\s*\(\s*)([A-Z][a-z\-\u2010\u2011]*)(\s*\))/gy;
    re4.lastIndex = pos;
    let a4 = re4.exec(text_gen);
    if ( a4 ) {
     text_out += a4[1]+'<i>'+a4[2]+'</i>'+a4[3];
     pos = re4.lastIndex;
    }

    // subgen. sect. ser.
    text_out += text_gen.substr(pos).replace(
      /\b(cf\.|aff\.|genus|gen\.|subgenus|subgen\.|subg\.|section|sect\.|series|ser\.)\s+([A-Z][a-z\-\u2010\u2011]*)(\s|\)|$)/g,
     function(match,rank,name,post){
      return rank+' <i>'+name+'</i>'+post;
     }
    );
    
    // specific name or after
    if ( a1 ) {
     let [match, leader, specificName, trailer, sp] = a1;
     if ( sp ) { // sp. | spp.
      text_out += text_in.substr(a1.index);

     } else {
      // specific name
      text_out += leader+'<i>'+specificName+'</i>'+trailer;

      // subspecific name
      let re5 = /\s*([a-z][a-z\-\u2010\u2011]*)(\s|$)/gy;
      let pos = re1.lastIndex;
      re5.lastIndex = pos;
      let a5 = re5.exec(text_in);
      if ( a5 ) {
       let [match, subspecificName, delm] = a5;
       const humanNames = new Set([
        'da', 'de', 'del', 'den', 'di', 'du',
        'la', 'le', 'ten', 'ter', 'van', 'von', 'zur'
       ]);
       if ( !humanNames.has(subspecificName)
          && !keywords.has(subspecificName) ) {
        text_out += '<i>'+subspecificName+'</i>'+delm;
        pos = re5.lastIndex;
       }
      }

      // subsp. var. f.
      text_out += text_in.substr(pos).replace(
        /\b(subsp\.|sub\.|ssp\.|var\.|forma|f\.)\s+([a-z][a-z\-\u2010\u2011]*)(\s|\)|$)/g,
       function(match,rank,name,post){
        return rank+' <i>'+name+'</i>'+post;
      });
     }
    }
    return text_out;
   }

   let text_out = '';
   let re = /(^|\s)\s*x\s+|\u00d7/g;
   let pos1 = 0;
   for( let a; a = re.exec(text_in);){
    let pos2 = a.index;
    if ( pos2 > pos1 ) {
     text_out += italicizePrimary(text_in.substring(pos1,pos2));
    }
    text_out += a[0];
    pos1 = re.lastIndex;
   }
   let pos2 = text_in.length;
   if ( pos2 > pos1 ) {
     text_out += italicizePrimary(text_in.substring(pos1,pos2));
   }
   return text_out;

  }

  // tempolary replace '<', '>'
  let t = input.replace(/</g,'<<').replace(/>/g,'>>');

  if ( italicBegin && t.indexOf(italicBegin) >= 0 ) {
   t = italicizeManual(t);
  } else {
   if ( options.symbols === 'forPrinting' ) {
    t = t.replace(/(\s)'([A-Z][^']*)'/g,` \u2018$2\u2019`);
      // quotation marks
    t = t.replace(/'/g,'\u2019'); // apostrophe
    t = t.replace(/\bx\b/g, '\u00d7'); // multiplication sign
   }
   t = italicizeAuto(t);
  }

  // escape '<' '>' '&'
  t = t.replace(/&/g,'&amp;')
    .replace(/<</g,'&lt;').replace(/>>/g,'&gt;');

  return t;
 };

})();
