var spelamModuleGeocoord;
(function(){
 'use strict';

 const GC = spelamModuleGeocoord = {};


 // 35°51′23″N  ->
 function toDecimalDegree(text){
  if ( text == null ) { return; }
  let a = text.match(
   /^[^\-\d]*(\-)?([\d\.]+)(?:\D+([\d\.]+)(?:\D+([\d\.]+))?)?\D*([NSEW])/);
  if ( !a ) {
   throw "ERROR";
  }
  let sign = a[1] === undefined? 1: -1;
  let degrees = parseFloat(a[2]);
  let minutes = parseFloat(a[3]||0);
  let seconds = parseFloat(a[4]||0);
  let direction = a[5];
  let dd = sign*(degrees + minutes/60 + seconds/3600);
  if ( direction.match(/[SW]/) ) {
   dd = -1 * dd;
  }
//console.log(degrees, minutes, seconds, dd );
// direction
  return dd;
 }


 GC.parse = function(text,latitudinal){
  let degree;
  if ( text == null ) { return; }
  if ( text.match(/[NSEW]/) ) {
   let element;
   if ( text.match(/^\s*[NSEW]/) ) {
    let a;
    if ( latitudinal ) {
     a = text.match(/([NS])([^NSEW]+)/);
    } else {
     a = text.match(/([EW])([^NSEW]+)/);
    }
    if ( a ) { element = a[2]+a[1]; }
   } else {
    let a;
    if ( latitudinal ) {
     a = text.match(/([^NSEW]+[NS])/);
    } else {
     a = text.match(/([^NSEW]+[EW])/);
    }
    if ( a ) { element = a[1]; }
   }
   degree = toDecimalDegree(element);
  } else {
   let element;
// ,オプション
   if ( text.match(/,/) ) {
    let a = text.split(/[,]/);
    element = latitudinal? a[0]: a[1];
   } else {
    element = text;
   }
   degree = parseFloat(element.trim());
  }
  return degree;
 };


 GC.format = function(options,degree_in,latitudinal){
  if ( degree_in == null ) { return; }
  let text;
  let format, decimalPlaces;
  if ( options.format != null ) {
   let a = options.format.match(/^(DMS|DM|D|DEC)(?:\.(\d+))?$/);
   if ( a ) { format = a[1]; decimalPlaces = a[2]; }
  }
  if ( format == null ) { format = 'DMS'; }
  let symbols = options.symbols === 'forPrinting'
   ? `\u00B0\u2032\u2033`: `\u00B0\u0027\u0022`;
  let [degreeSymbol, minuteSymbol, secondSymbol] = symbols.split('');

  let direction = latitudinal? 'N': 'E';
  let v = degree_in;
  if ( v < 0 ) {
   direction = latitudinal? 'S': 'W';
   v = -v;
  }
  let dp;
  if ( decimalPlaces ) { dp = parseInt(decimalPlaces); }
  switch(format){
   case 'DMS':
   default:
    {
     if ( !Number.isInteger(dp) ) { dp = 0; }
     let frac = '';
     v = v*3600;
     if ( dp > 0 ) {
      let [ip,fp] = v.toFixed(dp).split('.');
      frac = '.'+fp;
      v = parseInt(ip);
     } else {
      v = Math.round(v/Math.pow(10,-dp))*Math.pow(10,-dp);
     }
     let k = v%60;
     let seconds = ('0'+k).substr(-2);
     v = Math.round((v-k)/60);
     k = v%60;
     let minutes = ('0'+k).substr(-2);
     v = Math.round((v-k)/60);
     let degrees = v.toString();
     text = degrees+(degreeSymbol)+
            minutes+(minuteSymbol)+
            seconds+frac+(secondSymbol)+
            direction;
    }
    break;

   case 'DM':
    {
     if ( !Number.isInteger(dp) ) { dp = 2; }
     let frac = '';
     v = v*60;
     if ( dp > 0 ) {
      let [ip,fp] = v.toFixed(dp).split('.');
      frac = '.'+fp;
      v = parseInt(ip);
     } else {
      v = Math.round(v/Math.pow(10,-dp))*Math.pow(10,-dp);
     }
     let k = v%60;
     let minutes = ('0'+k).substr(-2);
     v = Math.round((v-k)/60);
     let degrees = v.toString();
     text = degrees+(degreeSymbol)+
            minutes+frac+(minuteSymbol)+
            direction;
    }
    break;

   case 'D':
    {
     let degrees;
     if ( !Number.isInteger(dp) || dp < 1 ) { dp = 4; }
     degrees = v.toFixed(dp);
     text = degrees+degreeSymbol+direction;
    }
    break;

    case 'DEC':
    {
     let degrees;
     if ( !Number.isInteger(dp) || dp < 1 ) { dp = 5; }
     degrees = v.toFixed(dp);
     text = degrees;
    }
    break;
    
  }
  return text;
 }



})();
