//
// slmm-date.js
//
var spelamModuleDate;

(function(){

 const DT = spelamModuleDate = {};


 // fullから作る
 const month_abbr = [
   'jan', 'feb', 'mar', 'apr', 'may', 'jun',
   'jul', 'aug', 'sep', 'oct', 'nov', 'dec'
 ];

 const month_roman = [
  'i'  , 'ii'  , 'iii', 'iv' , 'v'  , 'vi' ,
  'vii', 'viii', 'ix' , 'x'  , 'xi' , 'xii'
 ];


 const month_inv = {};
 for( let i = 0; i < month_abbr.length; i++ ) {
  month_inv[month_abbr[i]] = i;
 }
 for( let i = 0; i < month_roman.length; i++ ) {
  month_inv[month_roman[i]] = i;
 }

 const month_abbr_set = new Set(month_abbr);


 function parse_year(y){
  let v;
  if ( y !== undefined ) { v = Number(y); }
  return v;
 }


// rangeとか...
 function parse_month(m){
  let v;
  if ( m !== undefined ) {
   if ( m.match(/^\d/) ) {
    v = Number(m);
   }
   else {
    v = month_inv[m.substr(0,3).toLowerCase()];
    if ( v === undefined ) {
//     throw `invalid month: ${m}`;
// ちょっと
     v = 0;
    }
    v++;
   }
   if ( v < 1 || v > 12 ) {
// ちょっと
//     throw `invalid month: ${m}`;
    v = 1;
   }
  }
  return v;
 }


 function parse_day(d){
  let v;
  if ( d ) {
   v = Number(d);
   if ( v < 1 || v >= 31 ) {
console.log(d,v);
    throw `invalid day: ${d}`;
   }
  }
  return v;
 }


 // ISO8601 parser
 //  SMALL SUBSET!!
 //  ignore: time and time zone information
 //  unsupported: duration, century...

 function parseISO8601(options,text){

  let date0, date1;

  let [text0,text1] = text.split('/',2);

  text0 = text0.trim().replace(/(Z|[+\-]\d{2}(?:\-?\d{2}))$/,'');
  let a0 = text0.match(/^(\d{4})(?:\-?(\d{2})(?:\-?(\d{2})(?:T(\d{2}(?:[\.,]\d+)?)(?:\:?(\d{2}(?:[\.,]\d+)?)(?:\:?(\d{2}(?:[\.,]\d+)?))?)?)?)?)?$/);
  if ( !a0 ) { return; }
  a0.shift();
  date0 = [];
  date0[0] = parse_year(a0[0]);
  if ( a0[1] !== undefined ) {
   date0[1] = parse_month(a0[1]);
   if ( a0[2] !== undefined ) {
    date0[2] = parse_day(a0[2]);
   }
  }
  for( let i = 3; i < a0.length && a0[i] !== undefined; i++ ) {
   date0[i] = a0[i];
  }

  if ( text1 != undefined ) {
   text1 = text1.trim().replace(/(Z|[+\-]\d{2}(?:\:?\d{2}))$/,'');
   if ( date0.length > 3 ) {
    date0.length = 3;
    let pos = text1.search(/T/);
    if ( pos < 0 ) {
     // same day. e.g.  2018-02-03T08/15
     date1 = undefined;
     text1 = undefined;
    } else {
     // e.g. 2018-02-03T18/09T07
     text1 = text1.substr(0,pos);
    }
   }
   if ( text1 !== undefined ) {
    const re1 = [
     /^(\d{4})$/,
     /^(?:(\d{4})\-?)?(\d{2})$/,
     /^(?:(?:(\d{4})\-?)?(\d{2})\-?)?(\d{2})$/,
    ];
    let a1 = text1.match(re1[date0.length-1]);
    if ( a1 ) {
     a1.shift();
     date1 = [];
     date1[0] = a1[0] === undefined? date0[0]: parse_year(a1[0]);
     if ( a1.length >= 2 ) {
      date1[1] = a1[1] === undefined? date0[1]: parse_year(a1[1]);
     }
     if ( a1.length >= 3 ) {
      date1[2] = a1[2] === undefined? date0[2]: parse_year(a1[2]);
     }
    }
   }
  }

  if ( date0.length > 3 ) { date0.length = 3; }
  return [ date0, date1 ];
 };


 function parseCommonDate(options,date_str){
  let date0, date1, mdy;
  let ymd = date_str.match(/^\s*\d{4}/);
  let [str0,str1] = date_str.split(/[\-\u2010\u2011]/,2);
  if ( str1 !== undefined && !ymd ) {
   [str0,str1] = [str1,str0];
  }
  str0 = str0.trim();
  let a0 = str0.split(/\W+/,3);
  if ( !ymd ) {
   a0 = a0.reverse();
   if ( a0.length == 3 && !a0[1].match(/[a-z]/i) &&
      (a0[2].match(/[a-z]/i) || options.inputFormat === 'MDY') ) {
    [a0[1], a0[2]] = [a0[2], a0[1]];
    mdy = true;
   }
  }
  date0 = [];
  date0[0] = parse_year(a0[0]);
  date0[1] = parse_month(a0[1]);
  date0[2] = parse_day(a0[2]);
  if ( str1 !== undefined ) {
   str1 = str1.trim();
   a1 = str1.split(/\W+/,3);
   if ( !ymd ) { a1 = a1.reverse(); }
   let n = a0.length-a1.length;
   for( let i = 0; i < n; i++ ) {
    a1.unshift(undefined);
   }
   if ( mdy ) { [a1[1], a1[2]] = [a1[2], a1[1]]; }
   date1 = [];
   date1[0] = parse_year(a1[0]);
   date1[1] = parse_month(a1[1]);
   date1[2] = parse_day(a1[2]);
   for( let i = 0; i < 3; i++ ) {
    if ( date1[i] === undefined ) { date1[i] = date0[i]; }
   }
   if ( !ymd ) {
    [date0,date1] = [date1,date0];
   }
  }
  for( let i = 0; i < date0.length; i++ ) {
   if ( date0[i] === undefined ) { date0.length = i; break; }
  }
  if ( date1 !== undefined ) {
   date1.length = date0.length;
  }
  return [date0,date1];
 }


 DT.parse = function(options,date_str){
  let date_range;
  if ( options.inputFormat === undefined ||
     options.inputFormat === 'DMY' ||
     options.inputFormat === 'MDY' ) {
   date_range = parseCommonDate(options,date_str);
  }
  else if ( options.inputFormat === 'ISO' ) {
   date_range = parseISO8601(options,date_str);
  }
  else {
   throw "date: invalid argument";
  }
  return date_range;
 };


 // 
  /*
   format: 'DMY'
   componentSeparator:'.',      //  23.v.2018
         ' '
         '&nbsp;'
          ->できるんだっけ?
   rangeSeparator:'-',          //  3.iv-8.v.2018
   month:'rm'                   // iv
         'RM'                   // IV
         'm',                   // 1 .. 12
         'mm',                  // 01 .. 12
         'mon',                 // jan, feb, ..
         'Mon'                  // Jan, Feb, ..
         'MON'                  // JAN, FEB, ...
   day  : 'd'                   // 1 .. 31
          'dd'                  // 01 .. 31
   year : 'YYYY'                // 2018
  */
 DT.format = function(options,date_range){


  let dfmt,dmsep, mfmt, mysep, yfnt;
  if ( options.format ) {
   let a = options.format.match(/^(?:(?:([A-Za-z0-9]+)([^A-Za-z0-9]+))?([A-Za-z0-9]+)([^A-Za-z0-0]+))?([A-Za-z0-9]+)$/);
   if ( a ) {
    [dmy, dfmt, dmsep, mfmt, mysep, yfmt] = a;
   }
  }

  function formatDate( date, start_index ){
   let list = [];
   // day
   if ( dfmt != null && date.length > 2 && start_index <= 2 ) {
    let d = date[2];
    switch(dfmt){
     default    : 
     case 'd'   : v = d; break;
     case 'dd'  : v = ('0'+d).substr(-2); break;
    }
    list.push(v);
    if ( start_index < 2 ) {
     list.push(dmsep||' ');
    }
   }
   // month
   if ( mfmt != null && date.length > 1 && start_index <= 1 ) {
    let m = date[1];
    let v;
    switch(mfmt){
     case 'm'   : v = m; break;
     case 'mm'  : v = ('0'+m).substr(-2); break;
     case 'MON' : v = month_abbr[m-1].toUpperCase(); break;
     case 'Mon' : v = month_abbr[m-1].replace(/^[a-z]/,a=>a.toUpperCase());
                  break;
     case 'mon' : v = month_abbr[m-1]; break;
     case 'RM'  : v = month_roman[m-1].toUpperCase(); break;
     default    :
     case 'rm'  : v = month_roman[m-1]; break;
    }
    list.push(v);
    if ( start_index < 1 ) {
     list.push(mysep||' ');
    }
   }
   // year
   if ( date.length > 0 && start_index == 0 ) {
    list.push(date[0]);
   }
   return list.join('');
  }

  let date0 = date_range[0];
  let date1 = date_range[1];

  let n;
  if ( date1 !== undefined ) {
   // date0.length == date1.length;
   for( n = 0; n < date0.length && date0[n] == date1[n]; n++ ) {}
   if ( n >= date1.length ) {
    date1 = undefined;
   }
  }
  let text;
  if ( date1 === undefined ) {
   text = formatDate(date0,0);
  } else {
   text = formatDate(date0,n) + '\u2010' + formatDate(date1,0);
     // \u2010: hyphen
  }

  return text;
 }

})();
