//
// transform
//
(function(){
 'use strict';

 const S = spelam;

 let transformC = S.createComponent('transform');

 transformC.register('transform');

// パターン
// \d+ deg
 transformC.attributes.rotate = S.type.any();
 transformC.attributes.scaleX = S.type.any();
 transformC.attributes.scaleY = S.type.any();
 transformC.attributes.scale  = S.type.any();

 transformC.className = 'slm-transform';

/*
 -> slm-compile.js
 
 transformC.style = `
  .slm-transform {
   position: relative;
   display: inline-block;
   width:0; height: 0;
   white-space: nowrap;
  }
  .slm-transform > div{
   display: inline-block;
   position: absolute;
   top:0; left: 0;
   transform-origin: center center;
//   line-height:0;
  }
`;
*/

 transformC.preprocess = function(attributesExp,contentsSrc){
  let ctx = S.ctx;
  if ( ctx.inTextbox ) {
   ctx.error(`'transform' can't be placed in textbox`);
  }
  let level = ctx.transformNestLevel;
  if ( level === undefined ) {
   level = 0;
  } else {
   level++;
  }
  ctx.transformNestLevel = level;
// 関数
  if ( ctx.globalOptions.maxTransformNestLevel === undefined ||
    level > ctx.globalOptions.maxTransformNestLevel ) {
   // ->保存
   ctx.globalOptions.maxTransformNestLevel = level;
  }
// 
  S.ctx.options._transform_level = level;
 };


 transformC.func = function(attributes,contents){
  let rotation = 0;
  let s = attributes.rotate;
  if ( s ) {
   if ( !s.trim().match(/deg$/) ) {
    // エラー
    S.error("Rotation unit only supports 'deg'");
   }
   rotation = parseFloat(s);
  }
// 名前あれにするか
  let scaleX = attributes.scaleX;
  let scaleY = attributes.scaleY;
  let scale = attributes.scale;
  if ( scale !== undefined ) {
   scaleX = scaleY = scale;
  }
  return S.createElement('div',
    {'class':
      S.joinClassName(
       this.className, attributes.class,
       'slm-transform-'+S.ctx.options._transform_level
      ),
     _data_:{ rotation:rotation, scaleX: scaleX, scaleY: scaleY }
    },
    S.createElement('div',{},contents)
  );
 };


})();
