//
// textbox
//
(function(){
 'use strict';

 const S = spelam;

 let textboxC = S.createComponent('textbox');
 textboxC.register('textbox');

 textboxC.className = 'slm-tbox';

 textboxC.style = `
  .slm-tbox > div{
   display:inline-block;
   white-space: normal;
  }
`;

// パターン
//  /[\d\.]+(mm|pt|...)/
 textboxC.attributes.minWidth    = S.type.any();
 textboxC.attributes.maxWidth    = S.type.any();
 textboxC.attributes.minHeight   = S.type.any();
 textboxC.attributes.maxHeight   = S.type.any();
 textboxC.attributes.minFontSize = S.type.any();
 textboxC.attributes.maxFontSize = S.type.any();


 textboxC.precheck = function(attributesEx,contentsEx){
  let ctx = S.ctx;
  if ( ctx.inTextbox ) {
   // nest
   ctx.error("Textbox must not be nested.");
  }
  ctx.inTextbox = true;
 };
 

 textboxC.func = function(attributes,contents){
  let wdparam = sub('Width');
  let htparam = sub('Height');
  let fsparam = sub('FontSize');
  return S.createElement('div',{
   'class':S.joinClassName(this.className,attributes.class),
    style:attributes.style,
   _data_:{
    maxWidth: wdparam.max,
    minWidth: wdparam.min,
    widthUnit: wdparam.unit,
    maxHeight: htparam.max,
    minHeight: htparam.min,
    heightUnit: htparam.unit,
    maxFontSize: fsparam.max,
    minFontSize: fsparam.min,
    fontSizeUnit: fsparam.unit
   }},
   S.createElement('div',
    {},
    contents
   )
  );

  function sub(name){
   let min_str = S.applyScale(attributes['min'+name]);
   let max_str = S.applyScale(attributes['max'+name]);
   if ( min_str ) {
    if ( !max_str ) {
     // どうしよ
     // warning
     //
     S.error("max-width needed.");
    }
    let min = S.parseLength(min_str);
    let max = S.parseLength(max_str);
    if ( min.unit != max.unit ) {
     ctx.error("unit mismatch");
    }
    return {
     min: min.number,
     max: max.number,
     unit: min.unit
    };
   } else {
    return {};
   }
  }
 };

})();
