// source

(function(){
 'use strict';

 const S = spelam;

 let sourceC = S.createComponent('source');

 // 直下?
 sourceC.register('source');

 sourceC.attributes.caseConversion = S.type.set(
  ['camelCase','LCC','pascaleCase','UCC','kebabCase','snakeCase'],
  false, true
 );

// Delimiters
 sourceC.attributes.csvDelimiter = S.type.any(false,true);

 sourceC.parseMode = 'program';
 sourceC.contentsType = 'source';

 sourceC.preprocess = function(attributesExp,contentsSrc) {
  let s = attributesExp.get('caseConversion');
  if ( s !== undefined ) {
   switch(s){
    case 'LCC': s = 'camelCase'; break;
    case 'UCC': s = 'pascalCase'; break;
   }
   S.ctx.options.caseConversion = s;
  }
 };

 let fieldC = S.createComponent('field');
 fieldC.register('field','source');
 fieldC.attributes.name = S.type.name(true,true);
 fieldC.attributes.from = S.type.any(false,true);
 fieldC.attributes.default = S.type.any(false,true);

 fieldC.generate = function(attributesExp,contentsExp){
  let ctx = S.ctx;
  let name = attributesExp.get('name');
  let from = attributesExp.get('from');
  if ( from === undefined ) {
   from = name;
  }
  let defaultValue = attributesExp.get('default');
  if ( ctx.sources[name] ) {
   ctx.error(`field name '${name}' is already defined`);
  } else {
   ctx.sources[name] = { from: from, defaultValue: defaultValue };
  }
  S.ctx.root.defVar( name );
 }

})();
