//
// qrcode
//
(function(){
 'use strict';
 const S = spelam;
 let qrcodeC = S.createComponent('qrcode');
 qrcodeC.register('qrcode');

 qrcodeC.attributes.correctLevel = S.type.set(['L','M','Q','H']);

 qrcodeC.style = `
  .qrcode > svg {
   width: 100%;
   height: 100%;
  }
`;

 qrcodeC.func = function(attributes,contents){
  let text = S.docToString(contents);
  let div = document.createElement('div');
  div.className = attributes.class;
  if ( text !== undefined ) {
   let typeNumber = 0;  // auto
   let errorCorrectionLevel = attributes.correctLevel||'Q';
   let qr = qrcode(typeNumber, errorCorrectionLevel);
   qr.addData(text);
   qr.make();
   div.innerHTML = qr.createSvgTag(2,0);
   let svg = div.firstChild;
   svg.setAttribute('preserveAspectRatio',"xMidYMid meet");
   div.title = text;
  }
  return div;
 };

})();
