//
// latitude, longitude
//
(function(){
 'use strict';

 const S = spelam;
 const GC = spelamModuleGeocoord;


 let latlonC = S.createComponent('_geocoord','text');

 let latitudeC = S.createComponent('latitude','_geocoord');
 latitudeC.register('latitude');
 latitudeC.latitudinal = true;

 let longitudeC = S.createComponent('longitude','_geocoord');
 longitudeC.register('longitude');
 longitudeC.latitudinal = false;

 latlonC.attributes.format = S.type.pattern(
  /^(DMS|D|DEC)(\.\d+)?$/
 );
 latlonC.attributes.symbols = S.type.set(['forComputing','forPrinting']);

 latlonC.func = function(attributes,contents){
  let str = S.docToString(contents);
  if ( str === undefined ) { return; }

  let deg = GC.parse(str,this.latitudinal);
  if ( !isNaN(deg) ) {
   str = GC.format(attributes,deg,this.latitudinal);
  }
  return str;
 };


})();
