//
// date
//
(function(){

 const S = spelam;
 const DT = spelamModuleDate;

 const dateC = S.createComponent('date','text');
 dateC.register('date');

// パターンの指定!!
 dateC.attributes.inputFormat = S.type.set([
  'DMY', 'MDY', 'ISO'
 ]);
 dateC.attributes.format = S.type.pattern(
  /^(?:(?:(d|dd)([^A-Za-z0-9]+))?(rm|RM|Mon|MON|mon|M|MM)([^A-Za-z0-0]+))?(yyyy)$/
 );

 dateC.func = function(attributes,contents){
  let str = S.docToString(contents);
  if ( str === undefined ) { return; }

//
  let date_range = DT.parse(attributes,str);

//
  return DT.format(attributes,date_range);
 };

})();
