//
// user interface
// -> standalone.js
//
var spelamUseIframe;

(function(){
 'use strict';

 let S;

 let controller;

 let ruleSet;
 let dataSrc;
 let dataType;
 let dataFileName;
 let buildStatus;


 window.addEventListener('load',function(){
  start();
 },false);


 function $(id){
  return document.getElementById(id);
 }


 function openRuleFile(){
  openFileDialog({
    accept:'text/plain,text/xml,application/xml,application/json',
    multiple:false,
    name:'files[]'},
   function(files){
    loadRule(files[0]);
   }
  );
 };


 function openDataFile(){
  openFileDialog({
    accept:'text/plain,text/csv,text/comma-separated-values,application/vnd.ms-excel,text/xml,application/xml,application/json',
    multiple:false,
    name:'files[]'},
   function(files){
    loadData(files[0]);
   }
  );
 };


 function build(){
  if ( buildStatus ) {
   // cancel
   controller.cancel();
   buildStatus = false;
   $('build').innerHTML = 'Build';
   $('build').disabled = false;
  } else {
   // build
   buildStatus = true;
   $('build').disabled = false;
   $('build').innerHTML = 'Cancel';
   let ruleSrc = ruleSet.list[parseInt($('rule').value)];

   controller.reset();
   setMagnification();
   controller.setRule(ruleSrc,ruleSet.fileName);
   controller.setData(dataSrc,dataType,dataFileName);
   controller.scale = $('magnification').value;
   controller.repeat = $('repeat').value;
   controller.completionHandler = function(){
    buildStatus = false;
    $('build').innerHTML = 'Build';
   };
   controller.build();
  }
 }


 function checkRadioButton(name,value){
  let a = document.getElementsByName(name);
  for( let i = 0; i < a.length; i++ ) {
   a[i].checked = a[i].value == value;
  }
 }


 function createRuleMenu(){
  let options = [];
  for( let i = 0; i < ruleSet.list.length; i++ ) {
   let rule = ruleSet.list[i];
   let name = i;
   if ( rule && rule.attributes ) {
    name = rule.attributes.name;
   }
   options.push(
    `<option value="${i}">${htmlEscape(name)}</option>`
   );
  }
  $('rule').innerHTML = options.join('');
// 保存
  $('rule').value = "0";
 }


 function loadRule(file){
  readTextFile(file,function(text){
   let src = text;
   let newRuleSet = controller.importRule(src,file.name);
   if ( newRuleSet ) {
    ruleSet = newRuleSet;
    createRuleMenu();
    $('openRuleFile').innerHTML = htmlEscape(file.name);
    if ( ruleSet && dataSrc ) {
     $('build').disabled = false;
    }
    saveSettings();
   }
  });
 }


 function loadData(file){
  readTextFile(file,function(text){
   dataSrc = text;
   dataType = file.type;
   dataFileName = file.name;
   $('openDataFile').innerHTML = htmlEscape(file.name);
   if ( ruleSet && dataSrc ) {
    $('build').disabled = false;
   }
   saveSettings();
  });
 }


 function print(){
  if ( spelamUseIframe ) {
   $('iframe').contentWindow.print();
  } else {
   window.print();
  }
 };


 function setMagnification(){
  let scale = $('magnification').value;
  if ( isNaN(scale) || scale < 1/8 || scale > 8 ) {
   return;
  }
  if ( controller ) {
   controller.setMagnification(scale);
  }
 };


 function changeMagnification(){
  setMagnification();
  saveSettings();
 };


 function readTextFile(file,callback){
  let reader = new FileReader;
  reader.onloadend = function(){
   let text;
   if ( reader.error ) {
    console.log(reader.error);
   } else {
    text = reader.result;
   }
   callback(text);
  };
  let encoding = 'UTF-8';
  reader.readAsText(file,encoding);
 }


 // multiple??
 function openFileDialog(property,callback){
  let input = document.createElement('input');
  input.type = 'file';
  input.style.display = 'none';
  document.body.appendChild(input);
  for( let p in property ) {
   input[p] = property[p];
  }
  function onchange(ev) {
   input.removeEventListener('change',onchange,false);
   let files = ev.target.files;
   document.body.removeChild(input);
   callback(files);
  }
  input.addEventListener('change',onchange,false);
  let e = document.createEvent("MouseEvents");
  e.initMouseEvent("click", true, true, window,
   0, 0, 0, 0, 0, false, false, false,false, 0, null);
  input.dispatchEvent(e);
 }


 function htmlEscape(str) {
  if ( str == null ) { return ''; }
  return str.replace(/&/g, "&amp;").
   replace(/"/g, "&quot;").
   replace(/</g, "&lt;").
   replace(/>/g, "&gt;");
 }


 function showDropScreen(){
  let dropScreen = $('drop-screen');
  dropScreen.style.display = "block";
 }


 function hideDropScreen(){
  let dropScreen = $('drop-screen');
  dropScreen.style.display = "none";
 }


 function openFile(file){
  hideDropScreen();
  if ( file.name.match(/-slm\.[^\.]+$/i) ) {
   loadRule(file);
  } else {
   loadData(file);
  }
 }
 

// 埋め込め!
 function findFile(files) {
  let file;
  let accept = new Set([
        'text/plain',
        'text/csv',
        'text/comma-separated-values',
        'application/vnd.ms-excel',
        'text/xml',
        'application/xml',
        'application/json'
  ]);
  for (let i = 0, f; f = files[i]; i++) {
   console.log(f.type);
   if ( accept.has(f.type) ) {
    file = f;
    break;
   }
  }
  return file;
 }


 function onDrop(ev) {
  ev.stopPropagation();
  ev.preventDefault();
  hideDropScreen();
  let file = findFile(ev.dataTransfer.files);
  if ( file ) {
   openFile(file);
  }
 }


 function onDragOver(ev) {
  ev.stopPropagation();
  ev.preventDefault();
  ev.dataTransfer.dropEffect = 'copy';
 }


 function saveSettings(){
  let settings = {
   ruleFileName: ruleSet.fileName,
   ruleSrc: ruleSet.src,
   dataSrc: dataSrc,
   dataType: dataType,
   dataFileName: dataFileName,
   magnification: $('magnification').value,
   ruleNumber: $('rule').value,
  };
  let json = JSON.stringify(settings);
  try{
   localStorage.setItem('spelam.settings',json);
  }
  catch(e){
   console.log(e);
  }
 }


 function loadSettings(){
  let json = localStorage.getItem('spelam.settings');
  if ( json != null ) {
   // エラー?
   let settings = JSON.parse(json);
   let newRuleSet;
   try{
    newRuleSet = controller.importRule(settings.ruleSrc, settings.ruleFileName);
   }
   catch(e){
    console.log(e);
   }
   if ( newRuleSet ) {
    ruleSet = newRuleSet;
    dataSrc = settings.dataSrc;
    dataType = settings.dataType;
    dataFileName = settings.dataFileName;
    $('openRuleFile').innerHTML = ruleSet.fileName;
    $('openDataFile').innerHTML = dataFileName;
    createRuleMenu();
    if (settings.ruleNumber != null) {
     $('rule').value = settings.ruleNumber;
    }
    if (settings.magnification != null) {
     $('magnification').value = settings.magnification;
     setMagnification();
    }
    if ( ruleSet && dataSrc ) {
     $('build').disabled = false;
    }
   }
  }
 }


 function onresize(){
  if ( spelamUseIframe ) {
   let ifcontainer = $('iframeContainer');
   let iframe = $('iframe');
   iframe.setAttribute('width', ifcontainer.offsetWidth);
   iframe.setAttribute('height', ifcontainer.offsetHeight);
  }
 }


 function start(){

  if ( spelamUseIframe ) {
   let iframe = $('iframe');
   /*
   iframe.addEventListener('load',function(){
    let ifdocument = iframe.contentWindow.document;
    let S = iframe.contentWindow.spelam;
    console.log(S);
   },false);
   */
   S = iframe.contentWindow.spelam;
  } else {
   S = spelam;
  }

  controller = S.createController();


  $('rule').addEventListener('change', function(ev){
   if ( ruleSet && dataSrc ) {
    $('build').disabled = false;
   }
   saveSettings();
  }, false );

  window.addEventListener('resize', onresize, false );

  $('openRuleFile').addEventListener('click',function(){
   openRuleFile();
  },false);
  $('openDataFile').addEventListener('click',function(){
   openDataFile();
  },false);
  $('build').addEventListener('click',function(){
   build();
  },false);
  $('magnification').addEventListener('change',function(){
   changeMagnification();
  },false);
  $('print').addEventListener('click',function(){
   print();
  },false);

  function disable(ev){ ev.preventDefault(); }
  window.addEventListener('dragover', disable, false );
  window.addEventListener('drop', disable, false );
  window.addEventListener('dragenter', function(ev) {
   ev.preventDefault();
   showDropScreen();
  }, true );
  if ( spelamUseIframe ) {
   let iframe = $('iframe');
   let w = iframe.contentWindow;
   w.addEventListener('dragover', disable, false );
   w.addEventListener('drop', disable, false );
   w.addEventListener('dragenter', function(ev) {
    ev.preventDefault();
    showDropScreen();
   }, true );
  }

  let dropScreen = $('drop-screen');
  dropScreen.addEventListener('dragover', onDragOver, false);
  dropScreen.addEventListener('drop', onDrop, false );
  dropScreen.addEventListener('dragleave', hideDropScreen, false );

  $('build').disabled = true;

  onresize();
  loadSettings();

 }

})();
