//
// 

var spelam;

(function(){
 'use strict';

 const S = spelam = {};

 S.components = {};
 S.types = {};
 S.module = {};


 // context
 {
  let context = {};

  // dynamic scope
  S.ctx = context;

  context.create = function(){
   let ctx = Object.create(this);
   ctx.parent = this;
   return ctx;
  };


  context.setup = function(){
  };


  //  S.block(()=>{}
  //    ...
// -> 展開しておいたほうがデバッグが楽
  context.block = function(body){
   let ctxParent = S.ctx;
   let ctx = S.ctx = ctxParent.create();
   ctx.setup();
   let result;
   try{
    result = body.call(ctx);
   }
   catch(e){
    console.log(e);
    if ( e === 'FATAL' ) { throw e; }
   }
   finally{
    S.ctx = ctxParent;
   }
   return result;
  };


  context.maxErrorCount = 50;


  context.eval = function(exp){
   if ( exp === undefined ) { return; }
   let result;
   this.block(()=>{
    if ( exp.lineNumber !== undefined ) {
     S.ctx.lineNumber = exp.lineNumber;
    }
    let compo = S.components[exp.name];
    if ( compo === undefined ) {
     console.log(exp);
throw 'hoge';
    } else { 
     result = compo.eval(exp);
    }
   });
   return result;
  };

 }


 // S.ctx = 

 S.block = function(body){
  return S.ctx.block(body);
 };

 S.error = function(/*arguments*/){
  S.ctx.error.apply(S.ctx,arguments);
 };

 S.fatal = function(/*arguments*/){
  S.ctx.fatal(apply(S.ctx,arguments));
 };

 S.compileAttributes = function(type,attributes){
  return S.ctx.compileAttributes(type,attributes);
 };

 S.getVar = function(name){
  return S.ctx.getVar(name);
 };


 S.htmlEscape = function(str) {
  if ( str == null || str.toString == null ) {
   str = '';
  }
  else {
   str = str.toString().replace(/&/g, "&amp;").
    replace(/"/g, "&quot;").
    replace(/</g, "&lt;").
    replace(/>/g, "&gt;");
  }
  return str;
 };

 S.toCamelCase = function(s){
  if ( s != null ) {
   return s.replace(/^([A-Z])/,a=>a.toLowerCase()).
    replace(/[\-_]([a-z])/g,(match,a)=>a.toUpperCase());
  }
 };

 S.toPascalCase = function(s){
  if ( s != null ) {
   return s.replace(/^([a-z])/,a=>a.toUpperCase()).
    replace(/[\-_]([a-z])/g,(match,a)=>a.toUpperCase());
  }
 };

 // AbcDef -> abc-def
 S.toKebabCase = function(s){
  if ( s != null ) {
   return s.replace(/^[A-Z]/,a=>a.toLowerCase()).
    replace(/([A-Z])/g,(a)=>'-'+a.toLowerCase());
  }
 };

 // AbcDef -> abc_def
 S.toSnakeCase = function(s){
  if ( s != null ) {
   return s.replace(/^[A-Z]/,a=>a.toLowerCase()).
    replace(/([A-Z])/g,(a)=>'_'+a.toLowerCase());
  }
 };

 S.applyScale = function(str,scale){
  if ( isNaN(scale) ) { scale = S.ctx.scale; }
  return str == null? undefined:
   str.replace(/\b(\-?(?:[\d\.]+))(in|cm|mm|pt|pc|px)\b/g,
   (match,v,u)=>parseFloat(v)*scale + u);
 };

 S.parseLength = function(str){
  if ( str == null ) { return; }
  let a = str.match(/(\-?[\d\.]+)([a-z\%]+)/i);
  if ( a ) {
   return { number: parseFloat(a[1]), unit: a[2] };
  }
 };

/*
 S.compileContents = function(contentsSrc){
  S.ctx.compileContents(contentSrc);
 };
*/

 S.eval = function(exp){
  return S.ctx.eval(exp);
 };


 S.docToString = function(doc){
  let str;
  try{
   if ( doc == null ) {
    throw '';
   } else if ( typeof doc === 'object' ) {
    if ( doc.nodeType ) {
     if ( doc.textContent != null ) {
      str = doc.textContent;
     } else if ( doc.childNodes ) {
      str = Array.from(doc.childNodes).map(a=>S.docToString(a)).join('');
     } else {
      str = '';
     }
    } else if ( Array.isArray(doc) ) {
     str = doc.map(a=>a==null? '': S.docToString(a)).join('');
    } else if ( doc.contents ) {
     str = S.docToString(doc.contents);
    }
   } else if ( doc.toString ) {
    str = doc.toString();
   }
  }
  catch(e){
  }
  return str;
 };


 S.docToNode = function(doc) {
  let node;
  if ( doc == null ) { doc = ''; }
  if ( typeof doc === 'object' ) {
   if ( doc.nodeType ) {
    node = doc;
   } else if ( Array.isArray(doc) ) {
    node = document.createDocumentFragment();
    for( let i = 0; i < doc.length; i++ ) {
     let e;
     if ( doc[i] !== undefined ) {
      e = S.docToNode(doc[i]);
     }
     if ( e === undefined ) {
      e = document.createTextNode('');
     }
     node.appendChild(e);
    }
   } else {
    node = document.createTextNode(doc.toString());
   }
  } else {
   node = document.createTextNode(doc.toString());
  }
  return node;
 };


 // 
 S.cloneNode = function(doc){
  if ( doc == null ) {
   return undefined;
  } else if ( typeof doc === 'object' ) {
   if ( doc.nodeType ) {
    return doc.cloneNode(true);
   } else if ( Array.isArray(doc) ) {
    let a = [];
    for ( let i = 0; i < doc.length; i++ ) {
     a.push(S.cloneNode(doc[i]));
    }
    return a;
   }
  } else {
   return doc.toString();
  }
 };


/*
 contextに持って不明なやつも短くするか...
*/
 S.createElement = function(tagName,attributes,contents){
  let dom;
  let localName, namespaceURI;
  let a = tagName.split('$',2);
  if ( a.length == 2 ) {
   namespaceURI = a[0];
   localName = a[1];
   if ( S.nsAbbrUri[namespaceURI] ) {
    namespaceURI = S.nsAbbrUri[namespaceURI];
   }
   dom = document.createElementNS(namespaceURI,localName);
  } else {
   dom = document.createElement(tagName);
  }
  if ( attributes ) {
   for( let name in attributes ) {
    let a;
    let value = S.docToString(attributes[name]);
    if ( value !== undefined ) {
     if ( name === 'style' ) {
      dom.style.cssText = value;
     } else {
      let namespaceURI;
      let a = name.split('$',2);
      if ( a.length == 2 ) {
       namespaceURI = a[0];
       if ( namespaceURI === S.NS ) { continue; }
       if ( S.nsAbbrUri[namespaceURI] ) {
        namespaceURI = S.nsAbbrUri[namespaceURI];
       }
       localName = a[1];
      } else {
       namespaceURI = null;
       localName = a[0];
      }
      if ( localName.match(/^[a-zA-Z\-]/) ) {
       dom.setAttributeNS(namespaceURI,localName,value);
      }
     }
    }
   }
   if ( attributes._data_ ) {
    for( let name in attributes._data_ ) {
     let value = attributes._data_[name];
     if ( value != null ) {
      dom.dataset[name] = attributes._data_[name];
     }
    }
   }
  }
  let content_dom = S.docToNode(contents);
/*
  if ( content_dom === undefined ) {
   return;
  }
  dom.appendChild(content_dom);
*/
  if ( content_dom !== undefined ) {
   dom.appendChild(content_dom);
  }
  return dom;
 };


 // documentFragmentにinnerHTMLできない...
 S.createDOMFromHTMLText = function(text){
  if ( text == null ) { return; }
  let dom = document.createDocumentFragment();
  let dmy = document.createElement('div');
  dmy.innerHTML = text;
  for( let e = dmy.firstChild; e; e = e.nextSibling ){
   dom.appendChild(e.cloneNode(true));
  }
  return dom;
 };


 S.join = function(separator,list){
  let doc = [];
  for( let i = 0; i < list.length; i++ ) {
   let el = list[i];
   if ( doc.length > 0 && separator !== undefined ) {
    doc.push(S.cloneNode(separator));
   }
   if ( el !== undefined ) {
    // cloneNodeしておいたほうが安全ではあるがどうしよ。
    doc.push(el);
   }
  }
  return doc;
 };


 // attributesType
 S.stringType = function(required,mustbeconst,pattern){
  if ( pattern === undefined ) {
   pattern = /.*/;
  }
  return {
   type: 'string',
   regexp: pattern,
   mustbeconst: mustbeconst,
   required: required,
  };
 };



// 前
 const HTML_NS  = 'h';
 const SLM_NS   = 's';
 const SVG_NS   = 'svg';

 S.NS = SLM_NS;


 S.nsUriAbbr = {}; // SLM_NS -> 'S'
 S.nsAbbrUri = {}; // 'S' -> SLM_NS

 S.addNamespaceAbbr = function(namespaceAbbr,namespaceURI) {
  let uri = this.nsAbbrUri[namespaceAbbr];
  if ( uri !== undefined ) {
   if ( uri !== namespaceURI ) {
    console.log('#1592',namespaceAbbr,namespaceURI);
    throw "fatal";
   }
  }
  let abbr = this.nsUriAbbr[namespaceURI];
  if ( abbr !== undefined ) {
   if ( abbr !== namespaceAbbr ) {
    console.log('#1583',namespaceAbbr,namespaceURI);
    throw "fatal";
   }
  }
  this.nsAbbrUri[namespaceAbbr] = namespaceURI;
  this.nsUriAbbr[namespaceURI] = namespaceAbbr;
 };

 // とりあえず登録はいいか。

 S.addNamespaceAbbr(
  SLM_NS , "urn:uuid:43d584cc-5578-4a89-826b-f0ce4c0f96c0");
 S.addNamespaceAbbr(
  HTML_NS,"http://www.w3.org/1999/xhtml");
 S.addNamespaceAbbr(
  SVG_NS ,"http://www.w3.org/2000/svg");

 // Absolute Tag Name
 //  H$div
 //  S$scientificName




// ...
// Abbr
 S.toAbsoluteTagName = function(localName,namespaceURI){
  if ( namespaceURI == null ) {
   namespaceURI = S.NS;
  }
  return namespaceURI+'$'+localName;
 };



// 一般で使える
// buildにいれるか
 S.setStyleSheet = function(id,styleSheetText){
  let styleSheetEl = document.getElementById(id);
  if ( !styleSheetEl ) {
   styleSheetEl = document.createElement('style');
   styleSheetEl.id = id;
   let heads = document.getElementsByTagName('head');
   if ( heads === undefined ) {
    console.log('#1953');
    return;
   }
   heads[0].appendChild(styleSheetEl);
  }
  styleSheetEl.innerHTML = styleSheetText;
 };


 S.joinClassName = function(/**/){
  let className;
  for( let i = 0; i < arguments.length; i++ ) {
   let a = arguments[i];
   if ( a != null ) {
    if ( className === undefined ) {
     className = a;
    } else {
     className += ' '+a;
    }
   }
  }
  return className;
 };



// 
 function importJSON(text){
  let data;
  try{
   data = JSON.parse(text);
  }
  catch(e){
   console.log(e);
// 
  }
  return data;
 }


 function importCSV(text,options){
  if ( !options ) { options = {}; }
  let data;

  // detect delimiter
  let delimiter = options.csvDelimiter;
  if ( delimiter == null || delimiter === 'auto' ) {
   let b;
   if ( b = text.match(/([\t,;|])/) ) {
    delimiter = b[0];
   } else {
    throw `No delimiter`;
   }
  }
  let csvopt = {
   cast: false, header: true,
   delimiter: delimiter,
  };
  try{
   data = new CSV(text,csvopt).parse();
  }
  catch(e){
   console.log('ERROR',e);
  }

/*
// csv以外でもやるのでここではやらない。
build
  let conv;
  switch(options.caseConversion) {
   case 'camelCase' : conv = S.toCamelCase; break;
   case 'pascalCase': conv = S.toPascalCase; break;
   case 'kebabCase' : conv = S.toKebabCase; break;
   case 'snakeCase' : conv = S.toSnakeCase; break;
//
   default: conv = a=>a; break;
  }

  let data0 = data;
  data = [];
  for( let i= 0 ; i < data0.length; i++ ){
   let rec0 = data0[i];
   let rec = {};
   for( let name in rec0 ){
    let value = rec0[name];
//    if ( value === '' ) { value = undefined; }
    rec[conv(name)] = value;
   }
   data.push(rec);
  }
*/
  return data;
 }


 S.importData = function(source,type,options){
  let data;
  switch(type){
   case 'text/xml':
   case 'application/xml':
    {
     let xml = S.importXML(source);
     data = [];
     for( let i = 0; i < xml.contents.length; i++ ) {
      let xmlrec = xml.contents[i];
      if ( !xmlrec.contents ) { continue; }
      let rec = {};
      for( let j = 0; j < xmlrec.contents.length; j++ ) {
       let field = xmlrec.contents[j];
       if ( !field.tagName ) { continue; }
        // tagName
       let value = field.contents && field.contents.toString() !== ''?
         field.contents: undefined;
       rec[field.tagName] = value;
      }
      data.push(rec);
     }
    }
console.log(data);
    break;
   case 'application/json': data = importJSON(source); break;

   case 'text/csv':
   case 'text/plain':
   case 'text/comma-separated-values':
   case 'application/vnd.ms-excel':
     data = importCSV(source,options); break;
//   case 'raw': break;

//   default: S.error(`unsupported file type '${type}'`);
   default: throw `unsupported file type '${type}'`;

  }
  return data;
 }


 // importRule
 S.importRule = function(sourceText,fileName){
  let src = S.importXML(sourceText);
  let ruleSet = {};
  ruleSet.list = [];
  ruleSet.fileName = fileName;
  ruleSet.src = sourceText;
  if ( src.tagName !== S.toAbsoluteTagName('spelam') ) {
   throw `Not rule file (tagName = ${src.tagName})`;
  }
  let list = [];
  for( let i = 0; i < src.contents.length; i++ ){
   let rule = src.contents[i];
   if ( typeof rule === 'object' &&
      rule.tagName === S.toAbsoluteTagName('rule') ) {
    ruleSet.list.push(rule);
   }
  }
  return ruleSet;
 };



})();

