//
// slm-control
//
(function(){
 'use strict';

 const S = spelam;


// 
 S.windowId = 'slmWindow';
 S.previewWindowId = 'slmPreviewWindow';
 S.messageWindowId = 'slmMessageWindow';


 let controller = {};


 function $(id){
  return document.getElementById(id);
 }


 S.createController = function(){
  let c = Object.create(controller);
  c._vars = {};
  return c;
 };

 controller.status = undefined;

 controller.setRule = function(ruleSrc,fileName){
  this._vars.ruleSrc = ruleSrc;
  this._vars.ruleFileName = fileName;
 };

 controller.setData = function(dataSrc,type,fileName){
  this._vars.dataSrc = dataSrc;
  this._vars.dataType = type;
  this._vars.dataFileName = fileName;
 };


// setOption
// 未対応
 controller.batchFactor = 5;
 controller.maxErrorCount = 50;
 controller.scale = 1;


 controller.completionHandler = function(){
 };

 controller.progressHandler =
  function( totalCount,completedCount,errorCount){};


 function putMessage(htmltext){
  let messageWindow = $(S.messageWindowId);
  messageWindow.appendChild(S.createDOMFromHTMLText(htmltext));
  messageWindow.scrollTop = messageWindow.scrollHeight;
 }


 controller.importRule = function(src,fileName){
  let ruleSet;
  showMessageWindow();
  putMessage( `<p>Rule File Name: ${S.htmlEscape(fileName)}</p>` );
  try{
   ruleSet = S.importRule(src,fileName);
  }
  catch(e){
   if ( e.htmltext ) {
    putMessage(e.htmltext);
   } else {
    putMessage(S.htmlEscape(e));
   }
  }
  if ( ruleSet ) { showPreviewWindow(); }
  return ruleSet;
 };


 controller.build = function(){
  let vars = this._vars;
  if ( !vars.ruleSrc || !vars.dataSrc ) { return; }

  clearWindow();

// 
  let ruleFileName = S.htmlEscape(vars.ruleFileName);
  let ruleName = S.htmlEscape(vars.ruleSrc.attributes.name);
  putMessage( `<p>Compiling rule '${ruleName}' in file '${ruleFileName}'</p>`);

  // compile
  let compiler = S.createCompiler();
  compiler.src = vars.ruleSrc;
  compiler.fileName = vars.ruleFileName;
  compiler.exec();
  if ( compiler.status === 'ERROR' ) {
   let message = compiler.messages.map(a=>`<p>${a}</p>`).join('');
//   $(S.messageWindowId).innerHTML = message;
   putMessage(message);
   this.status = 'error';
   this.completionHandler();
   return;
  }
  let ruleExp = compiler.ruleExp;
  putMessage( `<p>Done.</p><hr/>`);

  putMessage(
   `<p>Load data file '${S.htmlEscape(vars.dataFileName)}'</p>`);
  let data;
  try {
   data  = S.importData(
    vars.dataSrc, vars.dataType, ruleExp.options
   );
  }
  catch(e){
   if ( e.htmltext ) {
    putMessage(e.htmltext);
   } else {
    putMessage(S.htmlEscape(e));
   }
  }
  if ( !data ) {
   this.status = 'error';
   this.completionHandler();
   return;
  }
  putMessage(`<p>Done.</p><hr/>`);

  showStatusWindow.call(this);

  // 
  let builder = S.createBuilder();
  this._builder = builder;
  builder.window = $(S.windowId);
  builder.messageWindow = $(S.messageWindowId);
  builder.previewWindow = $(S.previewWindowId);
  builder.ruleExp = ruleExp;
  builder.data = data;
  builder.progressHandler = progressHandler;
  builder.completionHandler = completionHandler;
  builder.maxErrorCount = this.maxErrorCount;
  builder.scale = this.scale;
  builder.repeat = this.repeat;
  builder.thisArg = this;
  builder.start();
 };

 let statusWindow;
 let cancelButton;
 let progressBar;

 // createStatusWindow
 function createStatusWindow(){
  if ( statusWindow ) { return; }
  cancelButton = S.createElement('button',{},'Cancel');
  progressBar = S.createElement('p',{});
  statusWindow = S.createElement('div',{
    id:'slmStatusWindow',
    style:`display: none;`
   },
   [
    S.createElement('div',{class:'mask'}),
    cancelButton,
    progressBar,
   ]
  );
  {
   progressBar.style.position = 'relative';
   progressBar.style.width = '100%';
//   progressBar.style.height = '1em';
   progressBar.style.outline = 'solid 1px #999';
   progressBar.innerHTML = `<div></div>`;
   let el = progressBar.firstChild;
   el.style.width = '0%';
   el.style.height = '100%';
   el.style.backgroundColor = '#3af';
  }
  let controller = this;
  cancelButton.addEventListener('click',function(ev){
   controller.cancel.call(controller);
   controller.completionHandler();
  });
  $(S.windowId).appendChild(statusWindow);
 }

 function showStatusWindow(){
  createStatusWindow.call(this);
  statusWindow.style.display = 'block';
 }

 function hideStatusWindow(){
  if ( statusWindow ) {
   statusWindow.style.display = 'none';
  }
 }


 // barBox, bar
// 
 function progressHandler( totalCount, completionCount, errorCount ){
  // this === controller
  if ( this._builder ) {
   let percent = Math.round(completionCount/totalCount*100);
   if ( isNaN(percent) ) { percent = 0; }
   if ( percent < 0 ) { percent = 0; }
   if ( percent > 100 ) { percent = 100; }
   let el = progressBar.firstChild;
   el.style.width = percent + '%';
   this.progressHandler(totalCount,completionCount,errorCount);
  }
 };


// cancel
 controller.cancel = function(){
  if ( this._builder ) {
   this._builder.cancel();
   if ( this._builder.status === 'completed' ) {
    hideStatusWindow();
    showPreviewWindow();
   }
   this._builder = undefined;
   this.status = 'completed';
  }
 };


 controller.reset = function(){
  this.cancel();
  clearWindow();
  hideStatusWindow();
  this.status = undefined;
 };


// S.
 controller.parseRule = function(){
 };


 // 
 controller.setMagnification = function(magnification){
  if ( isNaN(magnification) || magnification < 1/8 || magnification > 8 ) {
   magnification = 1;
  }
  const styleSheetId = 'slmPreviewStyle';
  S.setStyleSheet(styleSheetId,`
   @media screen{
    #${S.previewWindowId}{
     transform: scale(${magnification});
     -moz-transform: scale(${magnification});
     -webkit-transform: scale(${magnification});
     width: ${100/magnification}%;
    }
   }
`);
 };


 function showMessageWindow(){
  $(S.previewWindowId).style.visibility = 'hidden';
  $(S.messageWindowId).style.visibility = 'visible';
 }

 function showPreviewWindow(){
  $(S.messageWindowId).style.visibility = 'hidden';
  $(S.previewWindowId).style.visibility = 'visible';
 }

 function clearWindow(){
  $(S.messageWindowId).innerHTML = '';
  $(S.previewWindowId).innerHTML = '';
  showMessageWindow();
 }


 function completionHandler(){
  // this === controller!!
  let builder = this._builder;
  hideStatusWindow();
  if ( builder.status === 'completed' ) {
   showPreviewWindow();
   this.status = 'completed';
  }
  else {
   this.status = 'error';
  }
  this._builder = undefined;
  this.completionHandler();
 }


})();
