(function(){
 'use strict';

 const S = spelam;


 // type
 {
  let T = S.type = {};

  T.isconst = false;
  T.required = false;

  T.create = function(required,mustbeconst){
   let t = Object.create(this);
   t.required = required;
   t.mustbeconst = mustbeconst;
   return t;
  };

  T.test = function(str){ };

  {
   let anyT = T.create();

   anyT.test = function(str) {
    return true;
   };

   // constant
   T.any = function(required,mustbeconst){
    return anyT.create(required,mustbeconst);
   };

  }

  // pattern
  {
   let patT = T.create();

   patT.test = function(str){
    return this.pattern.test(str);
   };

   T.pattern = function(pattern,required,mustbeconst){
    let t = patT.create(required,mustbeconst);
    t.pattern = pattern;
    return t;
   };
   
  }

  // set
  {
   let setT = T.create();

   setT.test = function(str){
    return this.set.has(str);
   };

   // T.set(['text','program'],..)
   T.set = function(set,required,mustbeconst){
    let t = setT.create(required,mustbeconst);
    t.set = new Set(set);
    return t;
   };
   
  }


  // variable/constant name
  T.name = function(required,mustbeconst){
   return T.pattern(
    /^[a-z\u0080-\uffff][a-z_0-9\u0080-\uffff]*$/i, required, mustbeconst
   );
  };


  // class name
  // 
  T.className = function(required,mustbeconst){
   return T.pattern(
    /^[a-z_\u0080-\uffff][a-z_0-9\-\u0080-\uffff]*(\s+[a-z_\u0080-\uffff][a-z_0-9\-\u0080-\uffff]*)*$/i, required, mustbeconst
   );
  };

 }


 // component
 {
  let C = {};

  S.newComponent = function(name,supname){
   if ( name !== undefined ) {
    if ( S.components[name] ) {
     throw `component '${name}' already defined`;
    }
   }
   let sup;
   if ( supname ) {
    //
    sup = S.components[supname];
    if ( sup === undefined ) {
 // 
 // ctx.error呼べる?
     throw `component '${supname}' not defined`;
    }
   } else {
    sup = C;
   }
   let component = sup.create();
   if ( name !== undefined ) {
    component.name = name;
    S.components[name] = component;
   }
   component.attributes = Object.create(sup.attributes);
   return component;
  };

  C.create = function(){
   return Object.create(this);
  };


  C.name = '';

  C.attributes = {};
  C.parseMode = 'text';
  C.listMode = 'list';
  C.contentsType = 'component';
  C.attributes._splmln = S.type.any();


// 使ってない?
  C.registerNS = function(namespaceURI,localName,type){
   if ( type === undefined ) {
    type = 'component';
   }
   let table = S.types[type];
   if ( !table ) {
    table = S.types[type] = {};
   }
   let name = S.toAbsoluteTagName(localName,namespaceURI);
   if ( table[name] ) {
    throw `Component ${name} already used.`;
     // type
   }
   table[name] = this;
  };

  C.register = function(name,type){
   C.registerNS.call(this,undefined,name,type);
  };

  C.attributeNS = function(ns,name,type){
   this.attributes[ns+'$'+name] = type;
  };

  C.attributeAny = function(b){
   this.attributes.$any$ = b;
  };

  C.setMode = function(attributesExp){
   let ctx = S.ctx;
   let ns = this.isforeign? S.NS: undefined;
   let parseMode = this.parseMode;
   let listMode = this.listMode;
   let mode = attributesExp.get('mode',ns);
   switch(mode) {
    case 'text'  : parseMode = 'text'   ; listMode = 'list'  ; break;
    case 'list'  : parseMode = 'program'; listMode = 'list'  ; break;
    case 'array' : parseMode = 'program'; listMode = 'array' ; break;
    case 'series': parseMode = 'program'; listMode = 'series'; break;
   }
   let s;
   if ( (s = attributesExp.get('parseMode',ns)) ) { parseMode = s; }
   if ( (s = attributesExp.get('listMode',ns)) ) { listMode = s; }
   ctx.parseMode = parseMode;
   ctx.listMode = listMode;
  };


  C.compileContents = function(contentsSrc){
   let ctx = S.ctx;
   let exp;
   let listMode = ctx.listMode;
   if ( contentsSrc ) {
    let list = [];
    for( let i = 0; i < contentsSrc.length; i++ ) {
     let e = ctx.compileComponent(contentsSrc[i],this.contentsType)
     if ( e !== undefined ) {
      if ( Array.isArray(e) ) {
       list.push.apply(list,e);
      } else {
       list.push(e);
      }
     }
    }
    exp = S.genList(list,listMode);
   } else {
    exp = S.genArray([]);
   }
   return exp;
  };


  C.preprocess = function(attributesExp,contentsSrc){
  };


  C.compile = function(rule) {
   let ctx = S.ctx;
   ctx.lineNumber = rule.attributes._splmln;
   let attributesExp = S.compileAttributes(this.attributes,rule.attributes);
   this.setMode(attributesExp);
   if ( this.style ) {
    if ( !ctx.global[this.name] ) {
     ctx.global[this.name] = true;
     ctx.styles.push(this.style);
    }
   }
   this.preprocess(attributesExp,rule.contents);
   let contentsExp = this.compileContents(rule.contents);
   return this.generate(attributesExp,contentsExp);
  };

 
  C.generate = function(attributesExp,contentsExp){
   return S.genPrimitive(
    this.name, attributesExp, contentsExp, S.ctx.options
   );
  };


  C.func = function(attributes,contents){
   return contents;
  };


  C.eval = function(exp){
   let attributes = S.eval(exp.attributes);
   let contents = S.eval(exp.contents);
   S.ctx.options = exp.options;
   if ( attributes.generate === 'ifNotNull' && contents === undefined ) {
    return;
   }
   return this.func(attributes,contents);
  };

 }



 //
 // context
 //

 // これやると見えちゃうけどまぁいいか...
 let context = S.ctx.create();


 // context.block
 context.setup = function(){
  let parent = this.parent;
  this.defs = Object.create(parent.defs);
  this.attributes = {};
  this.options = {};
 };


 // htmlText版を..
 context.error = function(/*arguments*/){
  let messages = S.htmlEscape(Array.from(arguments).join(','));
//  let fileName = this.fileName;
  let lineNumber = this.lineNumber;
//  let htmltext = `${fileName}: ${lineNumber}: ${messages}`;
  let htmltext = `${lineNumber}: ${messages}`;
  this.messageList.push(htmltext);
  if ( this.messageList.length > this.maxErrorCount ) {
   this.messageList.push(
    `FATAL: too many errors.`
   );
   throw 'FATAL';
  }
 };


 context.fatal = function(/*arguments*/){
  let messages = S.htmlEscape(Array.from(arguments).join(','));
//  let fileName = this.fileName;
  let lineNumber = this.lineNumber;
//  let htmltext = `${fileName}:${lineNumber}: ${messages}`;
  let htmltext = `${lineNumber}: ${messages}`;
  this.messageList.push(htmltext);
console.log(htmltext);
  throw 'FATAL';
 };



 S.genPrimitive = function(name,attributesExp,contentsExp,options){
 // option...
  return {
   name: name,
   attributes: attributesExp,
   contents: contentsExp,
   lineNumber: S.ctx.lineNumber,
   options: options,
  };
 };


 // const
 {
  S.genConst = function(value){
   return {
    name: '_const', value: value
   };
  };

  let constC = S.newComponent('_const');

  constC.eval = function(exp){
   return exp.value;
  };
 }

 // get (var)
 {
  S.genGet = function(name){
   return { name: '_get', varname: name };
  };

  let getC = S.newComponent('_get');

  getC.eval = function(exp){
   return S.ctx.getVar(exp.varname);
  };
 }


 // 
 {
  S.genList = function(list, listMode){
   if ( listMode === undefined ) { listMode = 'list'; }
   return { name: '_'+listMode, list: list };
  };


  S.genArray = function(list){
   return { name: '_array', list: list };
  };
  

  //
  let arrayC = S.newComponent('_array');

  arrayC.eval = function(exp) {
   let list;
   if ( exp.list ) {
    list = [];
    for( let i = 0; i < exp.list.length; i++ ) {
     let value = S.eval(exp.list[i]);
     if ( value !== null ) { list.push(value); }
    }
   }
   return list;
  };

  let listC = S.newComponent('_list');

  listC.eval = function(exp){
   let list = [];
   if ( exp.list ) { 
    for( let i = 0; i < exp.list.length; i++ ) {
     let value = S.eval(exp.list[i]);
     if ( value != null ) { list.push(value); }
    }
   }
   return list.length === 0? undefined: list;
  };

  let seriesC = S.newComponent('_series');

  seriesC.eval = function(exp){
   let list;
   if ( exp.list ) {
    list = [];
    for( let i = 0; i < exp.list.length; i++ ) {
     let value = S.eval(exp.list[i]);
     if ( value === null ) { continue; }
     if ( value === undefined ) { list = undefined; break; }
     list.push(value);
    }
   }
   return list;
  };

 }


 context.defs = {};

 //
 const leftBrace   = '{{';
 const rightBrace  = '}}';
 {
  //
  function def(name,value){
   context.defs[name] = {
    name: '_const',
    value: value
   };
  };

  def('lb'         , leftBrace );
  def('leftbrace'  , leftBrace );
  def('rb'         , rightBrace );
  def('rightbrace' , rightBrace );
  def('empty'      , '' );
 }

 
 //
 context.compileLiteral = function(str){
  let list = [];
  let pos = 0;
  let pos1, pos2;
  let isconst = true;
  if ( str === '' ) {
   list.push(S.genConst(''));
  } else {
   for( ; (pos1 = str.indexOf(leftBrace,pos)) >= 0; ) {
    if ( pos1 > pos ) {
     list.push(S.genConst(str.substring(pos,pos1)));
    }
    pos1 += leftBrace.length;
    pos2 = str.indexOf(rightBrace,pos1);
    if ( pos2 >= 0 ) {
     let name = str.substring(pos1,pos2);
     if ( name === '' ) {
      // {{}} null
     } else if ( name.match(/^[a-z\u0100-\uffff][a-z_0-9\u0100-\uffff]*$/i) ) {
      let exp = this.defs[name];
      if ( exp === undefined ) {
       this.error(`Undefined var/const '${name}'.`);
      } else {
       isconst &= exp.name === '_const';
       list.push(exp);
      }
     } else {
      this.error(`Invalid name '${name}'.`);
     }
     pos = pos2 + rightBrace.length;
    } else {
     // 
     this.error(`Missing right double brace.`);
     pos = str.length;
    }
   }
   if ( pos < str.length ) {
    list.push(S.genConst(str.substr(pos)));
   }
  }
  return { isconst: isconst, list: list };
 };


 {
  // exp
  let attributesExpBase = {};

  attributesExpBase.name = '_attributes';

  attributesExpBase.get = function(localName,ns){

//   let name = S.toAbsoluteTagName(localName,ns);
   let name = (ns === undefined? '': ns+'$')+localName;

   let exp = this.defs[name];
   let value;
   if ( exp ) {
    // constは文字列だけ!!
    if ( exp.name === '_const' ) {
     value = exp.value;
    } else {
     value = S.docToString(S.eval(exp));
     exp.name = '_const';
     exp.value = value;
    }
   }
   return value;
  };

  let attributesC = S.newComponent('_attributes');

  attributesC.eval = function(exp){
   if ( exp === undefined ) { return; }
   let attributes = {};
   for( let name in exp.defs ) {
    let value = S.eval(exp.defs[name]);
    attributes[name] = S.docToString(value);
   }
   return attributes;
  };


  context.compileAttributes = function(attributesType,attributesSrc){
   let attributesExp = Object.create(attributesExpBase);
   attributesExp.defs = {};
   for( name in attributesSrc ) {
    let type = attributesType[name];
    if ( type === undefined ) {
     if ( !attributesType.$any$ ) {
      this.error(`Invalid attribute '${name}'.`);
     }
    }
    let info = this.compileLiteral(attributesSrc[name]);
    if ( type && type.mustbeconst ) {
     if ( !info.isconst ) {
      this.error(`Attribute '${name}' must be constant.`);
     }
    }
    let exp = S.genList(info.list);
    if ( info.isconst ) {
     let value = S.docToString(S.eval(exp));
     if ( type && !type.test(value) ) {
      this.error(`Invalid value '${value}' for attribute '${name}'.`);
      value = undefined;
     }
     exp.name = '_const';
     exp.value = value;
    }
    attributesExp.defs[name] = exp;
   }
   for( let name in attributesType ) {
    let type = attributesType[name];
    if ( type.required ) {
     if ( !attributesSrc[name] ) {
      this.error(`Attribute '${name}' required`);
     }
    }
   }
   return attributesExp;
  }
 }

//
 function makeAttrName(localName,namespaceURI){
  if ( namespaceURI == null ) {
   name = localName;
  } else {
   name = namespaceURI+'$'+localName;
  }
 }



 // const
 context.defConst = function(name,exp){
  if ( this.defs.hasOwnProperty(name) ) {
   this.error(`Constant '${name}' is already defined.`);
  } else {
   this.defs[name] = S.genConst(S.docToString(S.eval(exp)));
  }
 };


 // let
 context.defVar = function(name){
  if ( this.defs.hasOwnProperty(name) ) {
   this.error(`Variable '${name}' is already defined.`);
  } else {
   this.defs[name] = S.genGet(name);
  }
 };



// 評価時?
 context.getVar = function(name){
  //
  let exp = this.defs[name];
  if ( exp.name === '_const' ) {
   return exp.value;
  } else {
   this.error(`constant required.`);
  }
 };


 // CData
 function compileCData(cdata){
  let exp;
  let ctx = S.ctx;
  if ( ctx.parseMode === 'text' ) {
   let info = ctx.compileLiteral(cdata);
   exp = info.list;
    // array
  } else {
   if ( cdata != null && cdata.match(/\S/) ) {
    // 親の行番号になる
    ctx.error(`Characters can not be used in program mode.`);
   }
  }
  return exp;
 };


 context.compileComponent = function(rule,type){
  let exp;
  this.block(()=>{
   if ( typeof rule === 'object' ) {
// ctx.contentsType
    if ( !type ) { type = 'component'; }
    let table = S.types[type];
    if ( table === undefined ) {
     this.fatal(`#3291 '${type}'`);
    }
    let tagName = rule.tagName;
    let component = table[tagName];
    if ( component === undefined && rule.namespaceURI !== S.NS ) {
     component = table['s$_foreign'];
    }
    if ( component ) {
     exp = component.compile(rule);
    } else {
      let ctx = this.create(rule);
      ctx.lineNumber = rule.attributes._splmln;
      ctx.error(`unknown tag name '${tagName}'`);
    }
   }
   else {
    exp = compileCData(rule);
     // array
   }
  });
  return exp;
 };






 // rule
 {
  let ruleC = S.newComponent('rule');

// 
  S.ruleC = ruleC;

  ruleC.parseMode = 'program';
  ruleC.listMode = 'list';

  ruleC.attributes.name = S.type.any(true,true);

// type.float
  ruleC.attributes.scale = S.type.any(false,true);

  ruleC.style = `
   .slm-block{
    position: relative;
    display: inline-block;
    box-sizing: border-box;
    background-color: white;
    page-break-inside: avoid;
    vertical-align: top;
 /*   overflow: hidden; */
    line-height: 0;

   }
   .slm-transform {
    position: relative;
    display: inline-block;
    width:0; height: 0;
    white-space: nowrap;
    line-height: 1;
   }
   .slm-transform > div{
    display: inline-block;
    position: absolute;
    top:0; left: 0;
    transform-origin: center center;
   }
`;

  ruleC.compile = function(rule) {
   let ctx = S.ctx;
   ctx.root = ctx;
   ctx.defs = Object.create(ctx.parent.defs);
   ctx.global = {};
   ctx.sources = {};
   ctx.styles = [];
   ctx.userStyles = [];
   ctx.scripts = [];
   ctx.scale = 1;
   ctx.globalOptions = {};
   ctx.lineNumber = rule.attributes._splmln;
   let attributesExp = ctx.compileAttributes(
    this.attributes, rule.attributes
   );
// 反映?
   ctx.parseMode = 'program';
   ctx.listMode = 'list';
   let name = attributesExp.get('name');
   let scale = parseFloat(attributesExp.get('scale'));
   if ( isNaN(scale) ) {
    // 省略時とエラー時は別か
    scale = 1;
   }
   ctx.scale = scale;
    // 値の範囲
    // 大きくすると問題を生じるかもしれない。 safari
    // 10000 > scale >= 1
   ctx.transformNestLevel = 0;
   ctx.globalOptions.maxTransformNestLevel = 0;
   ctx.styles.push(this.style);
   ctx.defVar('recordNumber');
   let contentsExp = this.compileContents(rule.contents);
   //
   let exp = {};
   exp.name = 'rule';
   exp.styles = ctx.styles.concat(ctx.userStyles);
   exp.scripts = ctx.scripts;
   exp.scale = scale;
   exp.options = ctx.globalOptions;
   exp.sources = ctx.sources;
   exp.attributesExp = attributesExp;
   exp.contentsExp = contentsExp;
   return exp;
  };

  ruleC.eval = function(exp){
   let contents = S.eval(exp.contentsExp);
   return S.createElement('div',{'class':'slm-block'},
    S.createElement('div',
     {'class':'slm-transform slm-transform-0',
      _data_:{ scaleX:1/exp.scale, scaleY:1/exp.scale }
     },
     S.createElement('div',{}, contents||[])
    )
   );
  };
 }


 {
  let compiler = {};

  S.createCompiler = function(){
   return Object.create(compiler);
  };

  compiler.fileName = '';
  compiler.src = '';

  compiler.exec = function(){
   let ctxSave = S.ctx;
   let ruleExp;
   let messageList = [];
   try {
    S.ctx = context.create();
    S.ctx.messageList = messageList;
    S.ctx.fileName = this.fileName;
    ruleExp = S.ruleC.compile(this.src);
   }
   catch(e){
    console.log(e);
   }
   finally{
    S.ctx = ctxSave;
   }
   this.status = 'OK';
   if ( messageList.length > 0 ) {
    this.status = 'ERROR';
    this.messages = messageList;
   }
   this.ruleExp = ruleExp;
  };
 }


})();
