//
// build
//
(function(){
 'use strict';

 let S = spelam;

 let workingContainer;

 //
 // build context
 //
 let context = S.ctx.create();

 context.vars = {};


 context.setup = function(){
  let parent = this.parent;
  this.vars = Object.create(parent.vars);
// lineNumber
 };

 
 //
 context.putMessage = function(recordNumber,message){
  let list = this.messageList[this.recordNumber];
  if ( !list ) {
   list = this.messageList[recordNumber] = [];
  }
  list.push(message);
 };

 context.error = function(/*arguments*/){
  let messages = S.htmlEscape(Array.from(arguments).join(','));
  let recordNumber = this.recordNumber;
  let lineNumber = this.lineNumber;
  let htmltext = `<p>R#${lineNumber}: ${messages}</p>`;
  console.log(htmltext);
  this.putMessage(recordNumber,htmltext);
/*
個数 どうしよ カウンタ?
  if ( this.messageList.length > this.maxErrorCount ) {
   this.messageList.push(
    `FATAL: too many errors.`
   );

   throw 'FATAL';
  }
*/
 };


 context.fatal = function(/*arguments*/){
  let messages = S.htmlEscape(Array.from(arguments).join(','));
  let recordNumber = this.recordNumber;
  let lineNumber = this.lineNumber;
  let htmltext = `<p>R#${lineNumber}: ${messages}</p>`;
  console.log(htmltext);
  this.putMeessage(recordNumber,htmltext);
  throw 'FATAL';
 };



 context.defVar = function(name,exp){
//  let ctx = this.parent;
  let value = S.eval(exp);
  this.vars[name] = value;
 };


 context.getVar = function(name){
  return this.vars[name];
 };


 function start(){
  let ctxSave = S.ctx;
  let messageList = [];
  let message = '';
  try{
   this.status = undefined;
   if ( this.timer ) {
    clearTimeout(this.timer);
    this.timer = undefined;
   }
   this.completedBlocks = document.createDocumentFragment();
   let rule = this.ruleExp;
   let ctx = context.create();
   S.ctx = ctx;
   ctx.rule = rule;
   ctx.options = this.options;
   this.context = ctx;
   ctx.messageList = messageList;

   // generate style sheet
   {
    /*
      Safariのバグ対応まだ
       大きさがおかしくなるやつ...
    */
    const styleSheetId = 'splmGeneratedStyles';

 // 未定
    let text = `
     @page{
      margin-top:8mm;
      margin-bottom:12mm;
      margin-left:5mm;
      margin-right:5mm;
     }
 `;
    if ( rule.styles ) {
     text += rule.styles.join('\n');
    }
    S.setStyleSheet(styleSheetId,text);
   }


   // load script
   { 
    ctx.functions = {};
    let src = `'use strict';\n` + rule.scripts.join('\n');

    function scriptError(e){
     let msg = '';
     let a = src.split(/\n/);
     for( let i = 0; i < a.length; i++ ) {
      msg += (' '.repeat(4)+(i+1)).substr(-4,4);
      msg += ': ' + a[i];
      msg += '\n';
     }
     msg += e.message + '\n';
     msg += e.stack;
     messageList.push('<pre>'+S.htmlEscape(msg)+'</pre>');
    }

    let f;
    try{
     f = new Function(src);
    }
    catch(e){
     scriptError(e);
     throw 'FATAL';
    }

//
    let tmpctx = {};
    tmpctx.functions = {};
    tmpctx.defineFunction = function(name,func){
     this.functions[name] = func;
    };
    try{
     f.call(tmpctx);
    }
    catch(e){
     scriptError(e);
     throw 'FATAL';
    }
    ctx.functions = tmpctx.functions;
   }

   this.recordNumber = 1;
   this.numberOfRecords = this.data.length;
   this.errorCount = 0;

   // batchFactorから...
   // 2^batchFactor
   this.n = 20;

   let builder = this;
   this.timer = setTimeout(function(){ buildStep.call(builder); },0); 

   this.progressHandler.call( this.thisArg, this.data.length, 0,0 );
    // stopとかするなよ。
  }
  catch(e){
   console.log(e);
  }
  finally{
   S.ctx = ctxSave;
  }
  if ( messageList.length > 0 ) {
   if ( this.timer ) {
    clearTimeout(this.timer);
    this.timer = undefined;
   }
   this.messageWindow.innerHTML = messageList.join('');
   let builder = this;
   this.timer = setTimeout(function(){
    builder.timer = undefined;
    builder.status = 'error';
    builder.completionHandler.call(builder.thisArg);
   },0);
  }
 }

 function cancel(){
  if ( this.timer ) {
   clearTimeout(this.timer);
   this.timer = undefined;
   if ( this.errorCount === 0 ) {
    this.previewWindow.appendChild(this.completedBlocks);
    applyTransform.call(this,[this.previewWindow]);
   }
   this.status = 'completed';
  }
 }


 function makeBlocks(){
  let rule = this.ruleExp;
  for( let i = 0; i < this.n && this.recordNumber <= this.numberOfRecords;
     i++, this.recordNumber++ ) {
   let recordNumber = this.recordNumber;
   S.block(()=>{
    let ctx = S.ctx;
    ctx.scale = rule.scale;
    ctx.vars.recordNumber = recordNumber;
    ctx.recordNumber = recordNumber;
    let sources = rule.sources;
    let record = this.data[recordNumber-1];
    for( let name in sources ) {
     let field = sources[name];
     let value = record[field.from];
     if ( value == null || value === '' ) {
      value = field.defaultValue;
     }
     ctx.vars[name] = value;
    }
    let block = S.eval(rule);
    if ( block === undefined ) {
     ctx.fatal(`Unknown error`);
    }
//    block.id = 'slm-block-'+recordNumber;
    block.setAttribute('data-record-number', recordNumber);
    workingContainer.appendChild(block);
   });
  }
 }

 /*
  copyfit
   min-width
   min-height
   max-width
   max-height

   <div class="slm-tbox"
       data-font-size-min="3" data-font-size-max="4" >
                             // tbox_el
    <div>                     // content_el
    ...
    </div>
   </div>
 */
 function copyfit() {
  let vars = [];
  let a = workingContainer.getElementsByClassName('slm-tbox');
  for( let j = 0; j < a.length; j++ ) {
   let el = a[j];
   vars.push({
    box_el: el,
    content_el: el.firstChild,
    wd0: parseFloat(el.getAttribute('data-max-width')),
    wd1: parseFloat(el.getAttribute('data-min-width')),
    wdu: el.getAttribute('data-width-unit'),
    ht0: parseFloat(el.getAttribute('data-max-height')),
    ht1: parseFloat(el.getAttribute('data-min-height')),
    htu: el.getAttribute('data-height-unit'),
    fs0: parseFloat(el.getAttribute('data-min-font-size')),
    fs1: parseFloat(el.getAttribute('data-max-font-size')),
    fsu: el.getAttribute('data-font-size-unit')
   });
  }

  // bisection method
  // そんなに必要ない 5ぐらい?
  let precision = 8;   // 2^8
  for( let k = 0; k < precision; k++ ) {
   for( let i = 0; i < vars.length; i++ ) {
    let r = vars[i];
    let box_el = r.box_el;
    let el = r.content_el;
    if ( r.wdu ) { box_el.style.width    = (r.wd0+r.wd1)/2 + r.wdu; }
    if ( r.htu ) { box_el.style.height   = (r.ht0+r.ht1)/2 + r.htu; }
    if ( r.fsu ) { el.style.fontSize = (r.fs0+r.fs1)/2 + r.fsu; }
   }
   for( let i = 0; i < vars.length; i++ ) {
    let r = vars[i];
    let wd = (r.wd0+r.wd1)/2;
    let ht = (r.ht0+r.ht1)/2;
    let fs = (r.fs0+r.fs1)/2;
// getBoundingClientRect
    let box_el = r.box_el, content_el = r.content_el;
    if ( content_el.offsetWidth > box_el.offsetWidth 
      || content_el.offsetHeight > box_el.offsetHeight ) {
      r.wd1 = wd; r.ht1 = ht; r.fs1 = fs;
    }
    else {
      r.wd0 = wd; r.ht0 = ht; r.fs0 = fs;
    }
   }
  }
  for( let i = 0; i < vars.length; i++ ) {
   let r = vars[i];
   let box_el = r.box_el;
   let el = r.content_el;
   if ( r.wdu ) { box_el.style.width    = r.wd0 + r.wdu; }
   if ( r.htu ) { box_el.style.height   = r.ht0 + r.htu; }
   if ( r.fsu ) { el.style.fontSize = r.fs0 + r.fsu; }
  }

  // diagnosticsWindow
  let diagnostics = document.getElementById('diagnostics');

  function getRecordNumber(el){
   let recordNumber;
   for(; el && recordNumber == null; el = el.parentNode ) {
    recordNumber = el.getAttribute('data-record-number');
   }
   return recordNumber || 0;
  }

  for( let i = 0; i < vars.length; i++ ) {
   let r = vars[i];
// getBoundingClientRect
   let box_el = r.box_el, content_el = r.content_el;
   if ( content_el.offsetWidth > box_el.offsetWidth 
     || content_el.offsetHeight > box_el.offsetHeight ) {
    box_el.style.backgroundColor = "#fcc";
    let message = `<p>Text Overflow</p>`;
    S.ctx.putMessage(getRecordNumber(r.box_el),message);
   }
  }
 }


 function applyTransform(blocks,blockScale){
  if ( blockScale == null ) { blockScale = 1; }
  for( let level = this.ruleExp.options.maxTransformNestLevel;
    level >= 0; level-- ) {
   let list = [];
   let className = 'slm-transform-'+level;
   for( let i = 0; i < blocks.length; i++ ) {
    if ( !blocks[i].getElementsByClassName ) { continue; }
    let a = blocks[i].getElementsByClassName(className);
    for( let j = 0; j < a.length; j++ ) {
     let box_el = a[j];
     let content_el = box_el.firstChild;
     list.push({
      el: box_el,
      width: content_el.offsetWidth,
      height: content_el.offsetHeight
     });
    }
   }
   for( let i = 0; i < list.length; i++ ) {
    let r = list[i];
    let rotation = parseFloat(r.el.getAttribute('data-rotation'));
    if ( isNaN(rotation) ) { rotation = 0; }
    let scaleX = parseFloat(r.el.getAttribute('data-scale-x'));
    if ( isNaN(scaleX) ) { scaleX = 1; }
    let scaleY = parseFloat(r.el.getAttribute('data-scale-y'));
    if ( isNaN(scaleY) ) { scaleY = 1; }
    if ( level === 0 ) {
     scaleX *= blockScale; scaleY *= blockScale;
    }
    let width1 = r.width;
    let height1 = r.height;
    let t = Math.PI*rotation/180;
    let x0 = width1/2*scaleX;
    let y0 = height1/2*scaleY;
    let x1 = x0, y1 = -y0;
    let x = Math.max(Math.abs(x0*Math.cos(t) - y0*Math.sin(t)),
      Math.abs(x1*Math.cos(t)-y1*Math.sin(t)));
    let y = Math.max(Math.abs(x0*Math.sin(t) + y0*Math.cos(t)),
      Math.abs(x1*Math.sin(t)+y1*Math.cos(t)));
    let width0 = Math.abs(x)*2;
    let height0 = Math.abs(y)*2;
    let offsetX = -width1/2+Math.abs(x);
    let offsetY = -height1/2+Math.abs(y);
    let transform = `translate(${offsetX}px,${offsetY}px)`;
    if ( rotation != 0 ) {
     transform += ` rotate(${rotation}deg)`;
    }
    if ( scaleX != 1 || scaleY != 1 ) {
     transform += ` scale(${scaleX},${scaleY})`;
    }
    r.el.firstChild.style.transform = transform;
    r.el.firstChild.style.WebkitTransform = transform;
    r.el.firstChild.style.MozTransform = transform;
    r.el.style.width = width0 + 'px';
    r.el.style.height = height0 + 'px';
   }
  }
 }

 //
 function buildStep(){
  let ctxSave = S.ctx;
  try{
   this.timer = undefined;
   S.ctx = this.context.create();
   S.ctx.messageList = [];
   if ( !workingContainer ) {
    workingContainer = S.createElement('div',{
     style:`
       position: absolute; left: 0; top: 0; visibility: hidden;
     `},
     'hoge'
    );
    this.window.appendChild(workingContainer);
   } else {
    workingContainer.innerHTML = '';
   }
   makeBlocks.call(this);
   copyfit.call(this);

   let a = Object.keys(S.ctx.messageList);
   let errorRecords = new Set(a);
   this.errorCount += a.length;

   let blocks = Array.from(workingContainer.childNodes);
   let errorBlocks = [];
   for( let i = 0; i < blocks.length; i++){
    let el = blocks[i];
    if ( el.nodeType !== Node.ELEMENT_NODE ) { continue; }
    workingContainer.removeChild(el);
    let recordNumber = el.getAttribute('data-record-number');
    if ( errorRecords.has(recordNumber) ) {
     errorBlocks.push(el);
     this.messageWindow.appendChild(
      S.docToNode([
       S.createDOMFromHTMLText(
       `<p>RECORD #${recordNumber}: ERROR</p>`
       ),
       S.createDOMFromHTMLText( S.ctx.messageList[recordNumber].join('') ),
       el,
       S.createElement('hr'),
      ])
     );
    } else {
     this.completedBlocks.appendChild(el);
     let n = this.repeat || 1;
     for( let j = 1; j < n; j++ ) {
      this.completedBlocks.appendChild(el.cloneNode(true));
     }
    }
   }
   if ( this.errorCount >= this.maxErrorCount ) {
     this.messageWindow.appendChild(
      S.docToNode([
       S.createDOMFromHTMLText(`<p>Too may errors.</p>`),
       S.createElement('hr'),
      ])
     );
   }
   applyTransform.call(this,errorBlocks,this.scale);
   if ( errorBlocks.length > 0 ) {
    this.window.scrollTop = this.window.scrollHeight;
   }

   this.progressHandler.call(
    this.thisArg,
    this.numberOfRecords, this.recordNumber, this.errorCount
   );

   let builder = this;
   if ( this.recordNumber < this.numberOfRecords &&
       this.errorCount < this.maxErrorCount ) {
    this.timer = setTimeout(function(){ buildStep.call(builder); }, 0);
   }
   else {
    // completed
    if ( this.errorCount === 0 ) {
     this.previewWindow.appendChild(this.completedBlocks);
     applyTransform.call(this,[this.previewWindow]);
     this.status = 'completed';
    } else {
     this.status = 'error';
    }
    this.timer = setTimeout(function(){
     builder.completionHandler.call(builder.thisArg);
    }, 0);
   }
  }
  catch(e){
  console.log(e);
   throw 'FATAL';
  }
  finally{
   S.ctx = ctxSave;
  }
 }


 {
  let builder = {};

  S.createBuilder = function(){
   return Object.create(builder);
  };

  builder.start = function(){ start.call(this); };

  builder.cancel = function(){ cancel.call(this); };
 }

})();
