#!/usr/bin/perl

use strict;

#
# packhtml.pl
#  packhtml.pl --min hoge.html > hoge-packed.html
#

sub read_file{
 my $path = shift;
 my $text;
 open(IN,'<',$path) || die "$path: $!";
 { local $/; $text = <IN>; }
 close IN;
 $text;
}

sub packhtml{
 my $path = shift;

 my $src_dir;
 my $filename;
 if ( $path =~ /^(.*)\/([^\/]*)$/ ) {
  $src_dir = $1;
  $filename = $2;
 } else {
  $src_dir = '.';
  $filename = $path;
 }

 my $source = "$src_dir/$filename";
 my $text = '';
 open(SRC,'<',$source) || die "can't open $source: $!";
 while(defined(my $line = <SRC>)){
 # print $line;
  if ( $line =~ /^<script/ ) {
   if ( $line !~ /src="([^"]+)"/ ) { die $line; }
   my $file = "$src_dir/$1";
   my $js = read_file($file);
   # remove 'use strict'; 一つしか見てないよ
   $js =~ s/'use strict';//; 
   $text .= "\n";
   $text .= "<!-- $file -->\n";
   $text .= "<script>\n";
   $text .= $js;
   $text .= "</script>\n";
  }
  elsif ($line =~ /^<link rel="stylesheet"/ ) {
   # ファイルの先頭にあること!
   # begin of line!!
   if ( !($line =~ /href="([^"]+)"/) ) { die $line; }
   my $file = "$src_dir/$1";
   $text .= "<!-- $file -->\n";
   $text .= "<style>\n";
   $text .= read_file($file);
   $text .= "</style>\n";
  }
  else {
   $text .= $line;
  }
 }
 close SRC;
 print $text;
}


my $s = shift;
if ( !$s ) {
 die "filename!";
}
packhtml($s);
