#!/usr/bin/perl

#
# mkarchive template.html ../release/archives > archive.html
#

use strict;
use POSIX 'strftime';

my $template = shift;
my $arcdir = shift;
my $urlprefix = shift;

if ( !$template ) { die "template!"; }
if ( !$arcdir ) { die "archive dir!"; }

if ( !$urlprefix ) {
 $urlprefix = '';
}

sub escape{
 my $s = shift;
 $s =~ s/&/&amp;/;
 $s =~ s/</&lt;/;
 $s =~ s/>/&gt;/;
 $s =~ s/"/&quot;/;
 $s;
};

my $text;
open(IN,'<',$template) || die "$template: $!";
{ local $/; $text = <IN>; }
close IN;

my @arclist = `ls $arcdir`;

my $table = "<table><tbody>\n";

for my $name( sort @arclist ) {
 chomp $name;
 my $path = "$arcdir/$name";
 my $URL = escape("$urlprefix$name");
 my $name_e = escape($name);
 my $size = '';
 if ( -f $path ) {
  $size = (-s $path) . ' B';
 } else {
  $URL = $URL.'/index.html';
  $name_e .= ' (online version)';
 }
 my $mtime = strftime("%Y-%m-%dT%H:%M:%SZ", gmtime((stat($path))[9])); 
 $table .= " <tr>\n";
 $table .= "  <td><a href=\"$URL\" download=\"$name\">$name_e</a></td>\n";
 $table .= "  <td>$size</td>\n";
 $table .= "  <td>$mtime</td>\n";
 $table .= " </tr>\n";
}
$table .= "</tbody></table>\n";


$text =~ s/__ARCHIVES__/$table/;

print $text;

