% Spelam \__VERSION__ User's Guide

Spelamは標本ラベルを作成するためのツールである。
標本データファイルととルールファイルから
自動的にラベルを生成する。
Spelamはウェブブラウザ上で動作する
ウェブアプリケーションであり、
特別なインストールなしに使える。
もちろんダウンロードすればオフラインで使用することができる。

Spelamは自動組版システムであり、
データを手動で編集する機能は持たない。
あふれ詰め込み機能(copy fitting)、
学名の自動イタリック化(不完全)、
日付や緯度経度のフォーマット変換、
QRコード (試験的)等の機能を持つ。

Spelamはフリーソフトであり(MITライセンス)、
完全に無保証であることを理解いただければ
誰もが自由に使用できる。

----

## 目次

<div class="toc">
* 1 [動作環境](#s1)
* 2 [関連ファイル](#s2)
* 3 [使い方](#s3)
* 4 [プリンタの設定](#s4)
* 5 [注意事項・制限事項](#s5)
* 6 [ライセンス](#licence)
* 7 [連絡先](#s7)
</div>

----


## 1 動作環境 {#s1}

ハード的にはパソコン、プリンタが必要になる。
ソフトとしては、ウェブブラウザ(Chrome, Safari, Edge, Firefox等)、
テキストエディタ、
データーベースからデータファイルを生成するツールなどが必要になる。


かなり新しい機能を使っているので古いブラウザでは動作しない。
特にIE (Microsoft Internet Explorer)では動作しない。
以下のブラウザので対応する予定だが、
現在(2018年5月)一部の環境でしか確認できていない。

<div class="border" >

Chrome          Firfox          Safari          Edge
-------         ------          ------          ------
66.0            59.0            10.1.1          ?

</div>




## 2. 関連ファイル {#s2}


### Spelam オンライン版

* [spelam \__VERSION__](spelam.html)


### サンプルルール

* [rule1-slm.xml](sample/rule1-slm.xml){download="rule1-slm.xml"}

### サンプルデータ

* [data1.txt](sample/data1.txt){download="data1.txt"} ―csv サンプル
* [data1.json](sample/data1.json){download="data1.json"} ―json サンプル
* [data1.xml](sample/data1.xml){download="data1.xml"} ―xml サンプル
* [large.txt](sample/large.txt){download="large.txt"} ―大きいデータ(1000件)
* [error.txt](sample/error.txt){download="error.txt"} ―あふれエラーがでるもの



### ドキュメント

* [ルールファイル仕様](rule.html)
* [データファイルフォーマット(工事中)](data.html)
* [関数(工事中)](function.html)
* [フロントエンドシステムへの組み込み方法(工事中)](embedded.html)


### ダウンロード
 
オフラインで使用する場合、および旧バージョンは
[Spelam Archive](http://tamagaro.net/tool/spelam/archive.html)から



## 3 使い方 {#s3}

### 3.1 準備

以下の2つのファイルを用意する。

#### (1) ルールファイル

 テキストエディタなどで書く。

 HTMLやCSSの知識がないと難しいので
 通常は誰かが作ったものを流量することになると思う。

 [サンプルをダウンロード](sample/rule1-slm.xml){download="rule1-slm.xml"}

 ルールファイルのフォーマットについては[こちら](rule.html)。

#### (2) データファイル

 データーベースからCSVファイルなどの形式で書き出す。

 [サンプルをダウンロード](sample/data1.txt){download="data1.txt"}

 データファイルのフォーマットについては[こちら](data.html)。


### 3.2 Spelamを起動

[オンライン版をいますぐ起動](spelam.html)

画面は上部にメニューバーがあって、その下はプレビュー領域になっている。
プレビュー表示ではラベルの間に余白があるが印字の際には詰めて表示される。

![](menu.png)


### 3.3 操作方法

(1) ルールファイルを開く。
 メニューから開くこともできるしドラッグ＆ドロップもできる。
 ドラッグ＆ドロップする場合、ウインドウ内のどこにでもドロップできるが、
 ファイル名の最後が'-spl.xml'になっている必要がある。
 もしファイルの内容を更新したらファイルのオープンをやり直すこと。
(2) ルールを選ぶ。
 ルールファイル内に複数のルールがしまわれていれば、その中から一つを選択する。
(3) データファイルを開く。
 メニューから開くかドラッグ＆ドロップする。
 ドラッグ＆ドロップの場合ファイル名の最後は'-spl.xml'であってはいけない。
 もしファイルの内容を更新したらファイルのオープンをやり直すこと。
(4) 必要なら繰り返し回数を指定する
(7) ビルドする
(6) 必要なら表示倍率の指定する
 表示倍率は画面表示の場合のみで印字結果には影響しない。
(8) 印字する


## 4 印字設定{#s4}


* 用紙サイズは自由に選べる。実際に使用する用紙の大きさを指定する。　
 ラベルは用紙に入るだけ横に並べられるので、
 用紙サイズや用紙方向は自由に選べる。
 1レコード分のラベルの途中では改行されないので横幅は十分な大きさが必要。
* 用紙方向はどちらでも良い。
* 『フチあり』にする。フチ無しにすると大きさが変わる。
* ヘッダー・フッターをオフに。
* Safariでは指定した大きさにはならないようだ。



## 5. 制限事項・注意事項{#s5}


### Safari

* 印字すると大きさが変わる。　
対応は難しそう。



###  Firefox

* プレビューでoutlineが表示されない。
 印字は表示されるが美しくない。



## 6. ライセンス{#licence}

外部のプログラムをいくつか利用したが、
すべてMITライセンス。


### 本体

Copyright (c) 2018 Akihide Koguchi

Licence: MIT


### QRコード生成

Copyright (c) 2009 Kazuhiko Arase

Licence: MIT

* <http://www.d-project.com/>
* <https://github.com/kazuhikoarase/qrcode-generator>



### CSV読み込み

Copyright (c) 2014 Kash Nouroozi

Licence: MIT

* <https://github.com/knrz/CSV.js/tree/dev>


### QRコード

The word "QR Code" is registered trademark of 
 DENSO WAVE INCORPORATED
 <http://www.denso-wave.com/qrcode/faqpatent-e.html>





## 7 連絡先{#s7}


