% 関数の定義方法
% DRAFT 2018-05-06


***工事中***

----

## 目次 {.toc}

* [1 概要](#s1)
* [2 関数定義](#s2)
        * [2.1 defineFunction](#s2_1)
        * [2.2 関数本体](#s2_2)
* [3 doc形式](#s3)
* [4 関数本体から使用できるメソッド](#s4)
        * [4.1 docToString](#s4_1)
        * [4.2 docToNode](#s4_2)
        * [4.3 getVar](#s4_3)
        * [4.4 createElement](#s4_4)
        * [4.5 cloneNode](#s4_5)
        * [4.6 error](#s4_6)
        * [4.7 fatal](#s4_7)

----


## 1. 概要 {#s1}

Javascriptで処理を定義できる。

デバッグが難しいので、
大掛かりなものはソースコードを修正したほうが良いと思う。


### 1.1 簡単な例 {#s1_1}

例を示す。
コンテンツ内の全ての小文字を大文字に変換する。
標準機能のcapitalizeと同じ処理を関数で実現した場合。

script要素は部品を置ける場所ならどこにでも書ける。

```{.xml .numberLines}
 <script><![CDATA[
  this.defineFunction('capitalize',function(attributes,contents){
   let doc;
   let str = this.docToString(contents);
   if ( str !== undefined ) {
    doc = str.toUpperCase();
   }
   return doc;
  });
 ]]></script>
 <call name="capitalize">{{country}}</call>
```





## 2 関数定義 {#s2}

### 2.1 defineFunction {#s2_1}

script内に書く。


```{.xml .numberLines}
<script><![CDATA[
 this.defineFunction(functionName1,functionBody1);
 this.defineFunction(functionName2,functionBody2);
 this.defineFunction(functionName3,functionBody3);
]]></script>
```

このスクリプトはbuild前に一度だけ呼ばれる。

thisはdefineFunctionメソッドと
定義済み関数のリストだけがしまわれている。



##### functionName

任意の文字列。

**英数字**

callで呼び出される名前。


##### functionBody

関数。次節を参照。





### 2.2 関数本体 {#s2_2}

thisは


```{.javascript}
 function(attributes,contents){
  let result = F(contents);
  return result;
 }
```

#### 2.2.1 attributes

評価済み。
連想配列で値は文字列化されている。

なおcallでは任意の属性を指定できる。

```{.xml}
 <call name="hoge" arg1="a">{{contents}}</call>
```

のように呼び出したとき、

```
 attributes.arg1 === "a"
```


#### 2.2.3 contents

評価済み。doc形式。
配列かundefined。

listModeによって変わる。

```{.xml}
 <call name="hoge" listMode="array">a{{}}<text>c</text></call>
  <!-- JS:[ "a", undefined, "c" ] -->
```


#### 2.2.4 result

doc形式を返す。


#### 2.2.5 例外

this.error(), this.fatal() を使う。




## 3 doc形式 {#s3}

spelamの内部データ形式。
contents, 変数の値がdoc形式。

以下のいづれか。再帰的に定義される。

> undefined ({{null}}の内部形式)  
> 文字列  
> DOM要素  
> docの配列  





## 4 関数本体内から使用できるメソッドなど {#s4}

### 4.1 docToString {#s4_1}

```{.javascript}
 str = this.docToString(doc);
```

### 4.2 docToNode {#s4_2}

docをDOM要素にする。
配列の場合は、DocumentFragmentを作成するので注意。

```{.javascript}
   node = this.docToNode(doc);
```

```

### 4.3 getVar {#s4_3}

変数の取得。結果はdoc。

```{.javascript}
   doc = this.getVar('name');
```

### 4.4 createElement {#s4_4}

DOM要素の作成。

```{.javascript}
 node = this.createElement('div',
  {'class':'hoge'},
  doc
 );
```

### 4.5 cloneNode {#s4_5}


```{.javascript}
 node = this.cloneNode(doc);
```


### 4.6 error {#s4_6}

メッセージを出力する。
制御は通常戻ってくるが、
エラーの個数の上限を超えた場合ビルドを終了する。

```{.javascript}
 this.error(`message`);
```


### 4.7 fatal {#s4_7}

メッセージを出力し、ビルドを終了する。

```{.javascript}
 this.fatal(`message`);
```
