% Spelam embedded

JavascriptベースのフロントエンドシステムからSpelamを呼び出す方法について。

***工事中***


<div class="toc">

## 目次



* 3 iframe版
        * 3.1 htmlの書き方
        * 3.2 グローバル変数の取り出し
        * 3.3 印字

</div>



## 関連ファイル

* spelam-if.html ―組み込み元サンプルhtml
* js/slm-standalone.js ―組み込み元サンプルJavascript
* spelam-embedded.html ―iframe版本体



## 検討事項

### sandboxとは?



### プレビューとエラー






## 2. 関数インターフェース


```{.javascript}
 var spelam;

 let ctrl = spelam.createController();
 ctrl.setRule(ruleSrc, fileName);
 ctrl.setData(dataSRc, dataType, fileName);
 ctrl.scale(scale);
 ctrl.repeat(repeacCount);
 ctrl.completionHandler = function(){
  ...
 };
 ctrl.build();
```

### spelam


### spelam.createController


### ctrl.setRule

### ctrl.setData

### ctrl.scale

### ctrl.repeat


ctrl.clear
### ctrl.reset


### ctrl.build


->
未処理?
すぐにエラーが発生したとき
setTimeout(competionHandler,0);



### competionHandelr

エラー


### progressHandelr


###  Cancel 

```
 ctrl.cancel();
```







## 3. iframe版

iframeを使うと
スタイルシートの干渉、class名やID等の重複等の問題を避けることができる。


ローカルファイルで起動している場合ダメ
 file://localhost/...


通常版とiframe版の違い

* iframe側のグローバル変数の取り出し
* リサイズ時の処理
* 印字



### 3.1 フロントエンドシステム側のhtmlの書き方

大きさが固定の場合は以下のようにすればよい。

```{.html}
  <iframe id="iframe" src="spelam-embedded.html"
   width="800" height="600"></iframe>
```

本体spelam-embedded.htmlは
フロントエンドシステムと同じディレクトリにコピーしておくこと。


ウインドゥの大きさにしたがてiframeの大きさを変えたい場合は、
iframeはリサイズしたときに、CSSだけで自動的に大きさを変更することが
できないようなのでJavascriptを用いて設定する。

親にdiv要素を入れておいてリサイズされたらその大きさに合わせる。

```{.html}
 <style>
  .iframeContainer{
   position: absolute;
   top: 0;
   bottom: 0;
   left: 0;
   right: 0;
   overflow: hiddedn;
  }
  iframe{
   border: none;
  }
 </style>

 <div class="iframeContainer">
  <iframe id="iframe" src="spelam-embedded.html"></iframe>
 </div>
```

```{.javascript}
 window.addEventListener(resize,onresize,false);
 function onresize(){
   let iframe = document.getElementById('iframe');
   let container = iframe.parentNode;
   iframe.setAttribute('width', container.offsetWidth);
   iframe.setAttribute('height', container.offsetHeight);
  }
 }
```


### 3.2 グローバル変数の取り出し

以下のようにしてグローバル変数を取り出せる。


```{.javascript}
 let iframe = document.getElementById('iframe');
 let spelam = iframe.contentWindow.spelam;
```


### 3.3 印字

ブラウザのメニューから印字するとうまくいかない。

```{.javascript}
 iframe.contentWindow.print();
```






